<?php
/**
 * @author    S.Isogai
 * @copyright 2007 momoutils project
 * @license   http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @link      http://momoutils.sourceforge.jp/
 */

header("Content-Type: text/html; charset=EUC-JP");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once("common.php");

$messageData = new MessageData();
$messageData->_name = $_POST['name'];
$messageData->_title = $_POST['title'];
$messageData->_message = $_POST['message'];
// ΥФǤܻ֤ư
$messageData->_date = gmdate("Y/m/d H:i:s", time() + 9 * 3600);
$messageData->_ip = $_SERVER['REMOTE_ADDR'];

if (!validateMessage($messageData)) {
    $postResultFlag = false;
    $err = $messageData->getError();
}
else {
    $result = writeMessage($messageData);
    if (is_object($result) && strcasecmp(get_class($result), 'Error') == 0) {
        $postResultFlag = false;
        $err = $result;
    }
    else {
        $postResultFlag = true;
    }
}

$messageData->sanitizingHtmlTagAll();
$messageData->replaceLineFeedAll();

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=EUC-JP">
    <title><?php print $bbsName; ?></title>
    <link rel="stylesheet" href="momosimplebbs.css" type="text/css">
</head>
<body>
<?php
if ($postResultFlag) {
    print "<p>Ƥޤ</p>";
}
else {
    print "<p>Ƥ˼Ԥޤ</p>";
    viewError($err);
}
?>
<h2></h2>
<div>
<table class="postmessage">
<tr>
    <td class="postmessage">̾</td>
    <td class="postmessage"><?php print $messageData->_name; ?></td>
</tr>
<tr>
    <td class="postmessage">ȥ</td>
    <td class="postmessage"><?php print $messageData->_title; ?></td>
</tr>
<tr>
    <td class="postmessage">ƻ</td>
    <td class="postmessage"><?php print $messageData->_date; ?></td>
</tr>
<tr>
    <td class="postmessage">IP</td>
    <td class="postmessage"><?php print $messageData->_ip; ?></td>
</tr>
<tr>
    <td class="postmessage"></td>
    <td class="postmessage"><?php print $messageData->_message ?></td>
</tr>
</table>
</div>
<a href="index.php"></a>
<div class="footer">
    <?php viewFooter(); ?>
</div>
</body>
</html>
