<?php
/**
 * @author    S.Isogai
 * @copyright 2007 momoutils project
 * @license   http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @link      http://momoutils.sourceforge.jp/
 */
require_once("common.php");

/**
 *
 */
class MessageData {
    var $_name;
    var $_title;
    var $_ip;
    var $_date;
    var $_message;

    var $validator;

    /**
     * Constructor
     */
    function MessageData($name="", $title="", $ip="", $date="", $message="") {
        $this->__construct($name, $title, $ip, $date, $message);
    }

    /**
     * PHP5 Constructor
     */
    function __construct($name="", $title="", $ip="", $date="", $message="") {
        $this->_name = $name;
        $this->_title = $title;
        $this->_ip = $ip;
        $this->_date = $date;
        $this->_message = $message;

        $this->validator = new Validator();
    }

    function sanitizingHtmlTagAll() {
        $this->_name = htmlspecialchars($this->_name, ENT_QUOTES);
        $this->_title = htmlspecialchars($this->_title, ENT_QUOTES);
        $this->_ip = htmlspecialchars($this->_ip, ENT_QUOTES);
        $this->_date = htmlspecialchars($this->_date, ENT_QUOTES);
        $this->_message = htmlspecialchars($this->_message, ENT_QUOTES);
    }

    function replaceLineFeedAll($flag_xhtml = false) {
        $this->_name = eregi_replace("\r|\n", "", $this->_name);
        $this->_title = eregi_replace("\r|\n", "", $this->_title);
        $this->_ip = eregi_replace("\r|\n", "", $this->_ip);
        $this->_date = eregi_replace("\r|\n", "", $this->_date);

        // ʸ<br>Ѵ
        $this->_message = eregi_replace("\r\n", "\n", $this->_message);
        $this->_message = eregi_replace("\r", "\n", $this->_message);
        if ($flag_xhtml){
            $this->_message = eregi_replace("\n", "<br />", $this->_message);
        }
        else {
            $this->_message = eregi_replace("\n", "<br>", $this->_message);
        }
    }

    function toLogString() {
        $strLog = "";
        $strLog .= $this->_date . "<>" . $this->_ip . "<>";
        $strLog .= $this->_title . "<>" . $this->_name . "<>";
        $strLog .= $this->_message ."\n";
        return $strLog;
    }

    function setValidateRule($namelen=0, $titlelen=0, $messagelen=0, $messagelinelen=0) {
        $this->validator->addRule($this->_name, "̾ɬܹܤǤ", "required");
        $this->validator->addRule($this->_name, "̾".$namelen."ʸǤ", "maxlen", $namelen);
        $this->validator->addRule($this->_title, "ȥɬܹܤǤ", "required");
        $this->validator->addRule($this->_title, "ȥ".$titlelen."ʸǤ", "maxlen", $titlelen);
        $this->validator->addRule($this->_message, "ƤɬܹܤǤ", "required");
        $this->validator->addRule($this->_message, "Ƥ".$messagelen."ʸǤ", "maxlen", $messagelen);
        $this->validator->addRule($this->_message, "ƤιԿ".$messagelinelen."İǤ", "maxline", $messagelinelen);
    }

    function validate() {
        return $this->validator->validate();
    }

    function getError() {
        return $this->validator->err;
    }
}


class Validator {
    /** error */
    var $err;
    var $_rule;
    
    /**
     * Constructor
     */
    function Validator() {
        $this->__construct();
    }

    /**
     * PHP5 Constructor
     */
    function __construct() {
        $this->err = new Error();
        $this->_rule = array();
    }

    function validate() {
        for ($ii = 0; $ii < count($this->_rule); $ii++) {
            switch ($this->_rule[$ii]->type) {
            case "maxlen":
                if (!$this->_checkMaxLength($this->_rule[$ii]->content, $this->_rule[$ii]->prop1)) {
                    $this->err->add($this->_rule[$ii]->message);
                }
                break;
            case "minlen":
                if (!$this->_checkMinLength($this->_rule[$ii]->content, $this->_rule[$ii]->prop1)) {
                    $this->err->add($this->_rule[$ii]->message);
                }
                break;
            case "required":
                if (!$this->_checkRequired($this->_rule[$ii]->content)) {
                    $this->err->add($this->_rule[$ii]->message);
                }
                break;
            case "maxline":
                if (!$this->_checkMaxLineLength($this->_rule[$ii]->content, $this->_rule[$ii]->prop1)) {
                    $this->err->add($this->_rule[$ii]->message);
                }
            }
        }

        return !$this->err->hasError();
    }

    function addRule($content, $message, $type, $prop1=0) {
        $this->_rule[] = new ValidateRule($content, $message, $type, $prop1);
    }
    
    function _checkMaxLength($data, $max) {
        if (mb_strlen($data) > $max) {
            return false;
        }
        return true;
    }

    function _checkMinLength($data, $min) {
        if (mb_strlen($data) < $min) {
            return false;
        }
        return true;
    }

    function _checkRequired($data) {
        if (is_null($data) || $data == "") {
            return false;
        }
        return true;
    }

    function _checkMaxLineLength($data, $max) {
        $data = eregi_replace("\r\n", "\n", $data);
        $data = eregi_replace("\r", "\n", $data);
        $count = substr_count($data, "\n");

        if ($count > $max) {
            return false;
        }
        return true;
    }

}

class ValidateRule {
    /** validate */
    var $content;
    /** 顼Υå */
    var $message;
    /** å */
    var $type;
    /** å˻Ѥ */
    var $prop1;

    function ValidateRule($ruleContent, $ruleMessage, $ruleType, $ruleProp1=0) {
        $this->__construct($ruleContent, $ruleMessage, $ruleType, $ruleProp1);
    }
    
    function __construct($ruleContent, $ruleMessage, $ruleType, $ruleProp1=0) {
        $this->content = $ruleContent;
        $this->message = $ruleMessage;
        $this->type = $ruleType;
        $this->prop1 = $ruleProp1;
    }
}

class Error {
    var $_error;

    /** 顼ζڤʸ */
    var $separator;
    /** 顼ɽإå */
    var $header;
    /** 顼θɽեå */
    var $footer;

    /**
     * 󥹥ȥ饯
     */
    function Error() {
        $this->__construct();
    }

    /**
     * PHP5 󥹥ȥ饯
     */
    function __construct() {
        $this->_error = array();
        $this->separator = $this->header = $this->footer = "";
    }

    /**
     * 顼ο롣
     * @return 顼ο
     */
    function count() {
        return count($this->_error);
    }
    
    /**
     * 顼ɲä롣
     * @param $message 顼å
     */
    function add($message) {
        $this->_error[] = $message;
    }

    /**
     * ƤΥ顼åɽ롣<br>
     * $separatorڤʸȤƽϤ롣<br>
     * 顼ʤв⤷ʤ
     */
    function showAllMessages() {
        $count = $this->count();
        if ($this->hasError) {
            return;
        }

        print $this->header;
        for ($ii = 0; $ii < $count; $ii++) {
            print $this->_error[$ii];
            if ($ii < ($count - 1)) {
                print $this->separator;
            }
        }
        print $this->footer;
    }

    /**
     * 顼¸ߤtrue顼ʤfalse֤
     * @retrun 顼¸ߤtrue顼ʤfalse֤
     */
    function hasError() {
        if ($this->count() < 1) {
            return false;
        }
        else {
            return true;
        }
    }
}

?>
