//******************************************************************************
//
// Simple MIDI Library / SMSequencer
//
// V[PTNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "mmsystem.h"
#include "SMEventMIDI.h"
#include "SMEventSysEx.h"
#include "SMEventMeta.h"
#include "SMSeqData.h"
#include "SMMsgTransmitter.h"
#include "SMOutDevCtrl.h"
#include "SMCommon.h"

namespace SMIDILib {


//******************************************************************************
// V[PTNX
//******************************************************************************
class SMIDILIB_API SMSequencer
{
public:

	//t
	enum Status {
		StatusPlay,
		StatusPause,
		StatusStop
	};

	//[Uv
	enum UserRequest {
		RequestNone,
		RequestPause,
		RequestStop
	};

	//RXgN^^fXgN^
	SMSequencer(void);
	virtual ~SMSequencer(void);

	//
	int Initialize(HWND hTargetWnd, unsigned long msgId);

	//|[gΉfoCXo^
	int SetPortDev(unsigned char portNo, const char* pProductName);

	//V[PXf[^o^
	int SetSeqData(SMSeqData* pSeqData);

	//tJn
	int Play();

	//tꎞ~
	void Pause();

	//tĊJ
	int Resume();

	//t~
	void Stop();

	//ĐXs[hݒin{j
	void SetPlaybackSpeed(unsigned long nTimes);

private:

	//RPN/NRPNI
	enum RPN_NRPN_Select {
		RPN_NULL,
		RPN,
		NRPN
	};

	//RPN
	enum RPN_Type {
		RPN_None,
		PitchBendSensitivity,
		MasterFineTune,
		MasterCourseTune
	};

	//t
	Status m_Status;
	unsigned long m_PlayIndex;
	UserRequest m_UserRequest;
	SMMsgTransmitter m_MsgTrans;

	//MIDIfoCXn
	SMOutDevCtrl m_OutDevCtrl;
	unsigned char m_PortNo;
	char m_PortDevName[SM_MIDIOUT_PORT_NUM_MAX][MAXPNAMELEN];

	//MIDIf[^n
	SMSeqData* m_pSeqData;
	SMTrack m_Track;
	SMEvent m_Event;

	//^C}[n
	UINT m_TimerID;
	unsigned long m_TimerResolution;
	unsigned long m_TimeDivision;
	unsigned long m_Tempo;
	unsigned long m_PrevTimerTime;
	unsigned long m_CurPlayTime;
	unsigned long m_PrevEventTime;
	double m_NextEventTime;
	unsigned long m_NextNtcTime;
	unsigned long m_PrevDeltaTime;
	unsigned long m_TotalTickTime;
	unsigned long m_PlaybackSpeed;

	//ߔԍn
	unsigned long m_TickTimeOfBar;
	unsigned long m_CurBarNo;
	unsigned long m_PrevBarTickTime;

	//sb`xh
	unsigned char m_PitchBendSensitivity[SM_MAX_PORT_NUM][SM_MAX_CH_NUM];

	//RPNn
	RPN_NRPN_Select m_RPN_NRPN_Select;
	unsigned char m_RPN_MSB[SM_MAX_PORT_NUM][SM_MAX_CH_NUM];
	unsigned char m_RPN_LSB[SM_MAX_PORT_NUM][SM_MAX_CH_NUM];

	//^C}[foCX
	int _InitializeTimerDev();
	int _ReleaseTimerDev();

	//|[g
	void _ClearPortInfo();
	void _ClearChInfo();
	int _OpenMIDIOutDev();
	int _CloseMIDIOutDev();

	//Ԑ
	int _UpdatePlayPosition();
	double _ConvTick2TimeMsec(unsigned long tickTime);
	unsigned long _ConvTimeMsec2Tick(unsigned long timeMsec);

	//MIDIo͏
	int _OutputMIDIEvent(unsigned char portNo, SMEvent* pEvent);
	int _SendMIDIEvent(unsigned char portNo, SMEventMIDI* pMIDIEvent);
	int _SendSysExEvent(unsigned char portNo, SMEventSysEx* pSysExEvent);
	int _SendMetaEvent(unsigned char portNo, SMEventMeta* pMetaEvent);
	int _WatchControlChange(unsigned char portNo, SMEventMIDI* pMIDIEvent);
	RPN_Type _GetCurRPNType(unsigned char portNo, unsigned char chNo);

	//̑
	int _ProcUserRequest();
	int _AllTrackNoteOff();

	//^C}[
	static void CALLBACK _TimerCallBack(UINT uTimerID, UINT uMsg, DWORD_PTR dwUser, DWORD_PTR dw1, DWORD_PTR dw2);

protected:

	int _OnTimer();

private:

	//ƃRs[RXgN^̋֎~
	void operator=(const SMSequencer&);
	SMSequencer(const SMSequencer&);

};

} // end of namespace

