//******************************************************************************
//
// Simple MIDI Library / SMSeqData
//
// V[PXf[^NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "SMCommon.h"
#include "SMTrack.h"
#include "SMBarList.h"
#include "SMPortList.h"
#include <string>
#include <list>

#pragma warning(disable:4251)

namespace SMIDILib {


//******************************************************************************
// V[PXf[^NX
//******************************************************************************
class SMIDILIB_API SMSeqData
{
public:

	//RXgN^^fXgN^
	SMSeqData();
	virtual ~SMSeqData(void);

	//----------------------------------------------------------------
	//f[^쐬n
	//----------------------------------------------------------------
	//SMFtH[}bgo^
	void SetSMFFormat(unsigned long smfFormat);

	//ԉ𑜓xo^
	void SetTimeDivision(unsigned long timeDivision);

	//gbNo^
	int AddTrack(SMTrack* pTrack);

	//gbNo^I
	int CloseTrack();

	//NA
	void Clear();

	//----------------------------------------------------------------
	//f[^擾n
	//----------------------------------------------------------------
	//SMFtH[}bg擾
	unsigned long GetSMFFormat();

	//ԉ𑜓x擾
	unsigned long GetTimeDivision();

	//gbN擾
	unsigned long GetTrackNum();

	//gbN擾
	int GetTrack(unsigned long index, SMTrack* pTrack);

	//}[Wς݃gbN擾
	int GetMergedTrack(SMTrack* pMergedTrack);

	//g[^`bN^C擾
	unsigned long GetTotalTickTime();

	//g[^tԎ擾
	unsigned long GetTotalPlayTime();

	//e|擾
	unsigned long GetTempo();

	//e|擾(BPM)
	unsigned long GetTempoBPM();

	//qL擾Fqƕ
	unsigned long GetBeatNumerator();
	unsigned long GetBeatDenominator();

	//ߐ擾
	unsigned long GetBarNum();

	//Rs[Cg擾
	const char* GetCopyRight();

	//^Cg擾
	const char* GetTitle();

	//߃Xg擾
	int GetBarList(SMBarList* pBarList);

	//|[gXg擾
	int GetPortList(SMPortList* pPortList);

private:

	typedef std::list<SMTrack*> SMTrackList;
	typedef std::list<SMTrack*>::iterator SMTrackListItr;

	typedef struct {
		unsigned long index;
		unsigned long deltaTime;
	} SMDeltaTimeBuf;

	typedef std::list<SMDeltaTimeBuf> SMDeltaTimeBufList;
	typedef std::list<SMDeltaTimeBuf>::iterator SMDeltaTimeBufListItr;

private:

	unsigned long m_SMFFormat;
	unsigned long m_TimeDivision;
	unsigned long m_TotalTickTime;
	unsigned long m_TotalPlayTime;
	unsigned long m_Tempo;
	unsigned long m_BeatNumerator;
	unsigned long m_BeatDenominator;
	unsigned long m_BarNum;
	std::string m_CopyRight;
	std::string m_Title;
	SMTrackList m_TrackList;
	SMTrack* m_pMergedTrack;

	int _MergeTracks();
	double _GetDeltaTimeMsec(unsigned long tempo, unsigned long deltaTime);
	int _GetTempo(unsigned long* pTempo);
	int _GetBeat(unsigned long* pNumerator, unsigned long* pDenominator);
	int _GetBarNum(unsigned long* pBarNum);
	int _CalcTotalTime();
	int _SearchText();

	//ƃRs[RXgN^̋֎~
	void operator=(const SMSeqData&);
	SMSeqData(const SMSeqData&);

};

} // end of namespace

#pragma warning(default:4251)

