//******************************************************************************
//
// MIDITrail / MTFont2Bmp
//
// tHgrbg}bvϊNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// w蕶񂪏܂ꂽrbg}bv쐬B
// 1s̕ɂ̂ݑΉBs͑ΉĂȂB
// rbg}bṽTCY͉4̔{ɂȂ悤ɒB

#pragma once

#include <list>


//******************************************************************************
//  tHgrbg}bvϊNX
//******************************************************************************
class MTFont2Bmp
{
public:

	//RXgN^^fXgN^
	MTFont2Bmp(void);
	virtual ~MTFont2Bmp(void);

	//NA
	void Clear();
	
	//tHgݒ
	//  IɌŒsb`ɂꍇisForceFixedPitchtruew肷
	int SetFont(const TCHAR* pFontName, unsigned long fontSize, bool isForceFixedPitch = false);

	//rbg}bv쐬
	int CreateBmp(const TCHAR* pStr);
	
	//rbg}bvTCY擾
	void GetBmpSize(unsigned long* pHeight, unsigned long* pWidth);
	
	//rbg}bvsNZ擾
	//  K17i(0x00`0x10)̃sNZlԂ
	//  ͈͊Ow肷0xFFԂ
	BYTE GetBmpPixcel(unsigned long x, unsigned long y);

private:

	typedef struct {
		GLYPHMETRICS glyphMetric;
		unsigned long bmpHeight;
		unsigned long bmpWidth;
		unsigned char* pBmp;
	} MTGlyphBmp;

	typedef std::list<MTGlyphBmp> MTGlyphBmpList;

private:

	TCHAR m_FontName[LF_FACESIZE];
	unsigned long m_FontSize;
	bool m_isForceFixedPitch;

	HFONT m_hFont;
	TEXTMETRIC m_TextMetric;
	MTGlyphBmpList m_GlyphBmpList;

	BYTE* m_pBmpBuf;
	unsigned long m_BmpHeight;
	unsigned long m_BmpWidth;
	
	int _CreateLogFont();
	int _CreateGlyphBmp(unsigned long code, MTGlyphBmp* pGB);
	int _CreateGlyphBmpList(const TCHAR* pStr);
	int _CreateBmpBuf();
	int _WriteGlyphToBmpBuf();

};

