﻿#include "pch.h"

#include "MXUwpMidi.h"

using namespace std;
using namespace winrt;
using namespace Windows::Foundation;
using namespace Windows::Security::Credentials::UI;
using namespace Windows::ApplicationModel::DataTransfer; // 追加
using namespace Windows::Foundation; // 追加
using namespace Windows::Devices::Midi; // 追加
using namespace Windows::Devices::Enumeration; // 追加
using namespace Windows::Storage::Streams;

void receiver(MidiInPort port, IMidiMessageReceivedEventArgs args);

jclass jcJNATest002 = NULL;
JavaVM* cbVM;
jmethodID cbCallText, cbCallShortMessage, cbCallLongMessage;

#define DEBUG_TRACE(x)
//#define DEBUG_TRACE(x) debugTrace(x)


void refCallText(const jchar* text);
void refCallShortMessage(jint device, jint message);
void refCallLongMessage(jint device, jbyteArray ptr);

void debugTrace(const wchar_t* t) {
    const jchar* jch = (const jchar*)t;
    refCallText(jch);
}

struct InputVer {
public:
    int _number;
    IMidiInPort _port;
    bool _nowExist;

    IAsyncOperation<MidiInPort> _opening;
    wstring _name;
    wstring _id;
};

vector<InputVer> inputVector;

struct OutputVer {
public:
    int _number;
    IMidiOutPort _port;
    bool _nowExist;

    IAsyncOperation<IMidiOutPort> _opening;
    wstring _name;
    wstring _id;
};

vector<OutputVer> outputVector;

void MXDeviceManager::InitObject() {
    if (initFlag) {
        return;
    }
    initFlag = true;
    InReload();
    OutputReload();
}

void MXDeviceManager::InReload() {
    if (!initFlag) {
        InitObject();
    }
    // まず、INPUTを列挙
    hstring sel = MidiInPort::GetDeviceSelector();
    IAsyncOperation<DeviceInformationCollection> list = DeviceInformation::FindAllAsync(sel);

    // Async待機
    while (list.Status() == Windows::Foundation::AsyncStatus::Started)
    {
        std::this_thread::sleep_for(std::chrono::microseconds(300));
    }

    DeviceInformationCollection col = list.GetResults();

    //既存リストのフラグをリセット
    for (InputVer already : inputVector) {
        already._nowExist = FALSE;
    }
    //新規だけ追加する
    for (unsigned int i = 0; i < col.Size(); ++i)
    {
        InputVer ver;
        ver._name = col.GetAt(i).Name();
        ver._id = col.GetAt(i).Id();
        ver._port = NULL;
        bool _already = FALSE;

        for (InputVer already : inputVector) {
            if (already._id.compare(ver._id) == 0) {
                already._nowExist = TRUE;
                ver._nowExist = TRUE;
                _already = TRUE;
                break;
            }
        }
        if (_already) {
            continue;
        }
        ver._number = inputVector.size();
        inputVector.push_back(ver);
    }
    //削除されたものを閉じる
    for (InputVer toremove : inputVector) {
        if (toremove._nowExist == FALSE) {
            //InClose(toremove._number);
        }
    }
}

int MXDeviceManager::InRoomSize() {
    if (!initFlag) {
        InitObject();
    }
    return inputVector.size();
}

const wchar_t* MXDeviceManager::InName(int device) {
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return NULL;
    }
    return inputVector[device]._name.c_str();
}
const wchar_t* MXDeviceManager::InId(int device) {
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return NULL;
    }
    return inputVector[device]._id.c_str();
}
bool MXDeviceManager::InIsOpen(int device) {
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return false;
    }
    return inputVector[device]._port != NULL;
}

bool MXDeviceManager::InQueryOpen(int device) {
    DEBUG_TRACE(L"InReserveOpen");
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (ver._port != NULL) {
        return true;//ALREAY OPEM;
    }
    if (ver._opening == NULL) {
        ver._opening = MidiInPort::FromIdAsync(ver._id);
    }
    return true;
}

bool MXDeviceManager::InIsOpening(int device) {
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (ver._port != NULL) {
        return false;//ALREAY OPEM;
    }
    if (ver._opening == NULL) {
        return false;
    }
    return true;
}

bool MXDeviceManager::InWaitDoneOpening(int device, long timeout) { //TRUE = timeout
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (InIsOpening(device) == FALSE) {
        return false;
    }
    if (timeout == 0) {
        /*
        Canceled = 2,
        Completed = 1,
        Error = 3,
        Started = 0,
        */
        while (ver._opening.Status() == Windows::Foundation::AsyncStatus::Started)
        {
            std::this_thread::sleep_for(std::chrono::microseconds(100));
        }
    }
    else {
        while (ver._opening.Status() == Windows::Foundation::AsyncStatus::Started)
        {
            std::this_thread::sleep_for(std::chrono::microseconds(100));
            timeout -= 100;
            if (timeout < 0) {
                return true;
            }
        }
    }
    if (ver._opening.Status() == Windows::Foundation::AsyncStatus::Completed) {
        ver._port = ver._opening.GetResults();
        ver._port.MessageReceived(receiver);
        ver._opening = NULL;
    }
    else if (ver._opening.Status() == Windows::Foundation::AsyncStatus::Error
      || ver._opening.Status() == Windows::Foundation::AsyncStatus::Canceled) {
        ver._opening = NULL;
        ver._port = NULL;
    }
    return false;
}

bool MXDeviceManager::InOpen(int device) {
    DEBUG_TRACE(L"InOpen");
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (InIsOpen(device)) {
        return true;
    }
    if (InQueryOpen(device)) {
        InWaitDoneOpening(device, 0);
        return InIsOpen(device);
    }
    return false;
}

bool MXDeviceManager::InClose(int device) {
    InputVer& ver = inputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (inputVector[device]._port != NULL) {
        inputVector[device]._port.Close();
        inputVector[device]._port = NULL;
        return true;
    }
    return false;
}

void MXDeviceManager::OutputReload() {
    if (!initFlag) {
        InitObject();
    }
    // まず、INPUTを列挙
    hstring sel = MidiOutPort::GetDeviceSelector();
    IAsyncOperation<DeviceInformationCollection> list = DeviceInformation::FindAllAsync(sel);

    // Async待機
    while (list.Status() == Windows::Foundation::AsyncStatus::Started)
    {
        std::this_thread::sleep_for(std::chrono::microseconds(300));
    }

    DeviceInformationCollection col = list.GetResults();

    //既存リストのフラグをリセット
    for (OutputVer already : outputVector) {
        already._nowExist = FALSE;
    }
    //新規だけ追加する
    for (unsigned int i = 0; i < col.Size(); ++i)
    {
        OutputVer ver;
        ver._name = col.GetAt(i).Name();
        ver._id = col.GetAt(i).Id();
        ver._port = NULL;
        bool _already = FALSE;

        for (OutputVer already : outputVector) {
            if (already._id.compare(ver._id) == 0) {
                already._nowExist = TRUE;
                ver._nowExist = TRUE;
                _already = TRUE;
                break;
            }
        }
        if (_already) {
            continue;
        }
        ver._number = outputVector.size();
        outputVector.push_back(ver);
    }
    /*
    boolean hasMicrosoft = false;
    for (unsigned int i = 0; i < outputVector.size(); ++i) {
        if (outputVector[i]._name.find(L"Microsoft GS Wavetable Synth") >= 0) {
            hasMicrosoft = true;
            outputVector[i]._nowExist = TRUE;
            DEBUG_TRACE(L"Microsoft Synthesizer A");
        }
    }
    if (!hasMicrosoft) {
        IAsyncOperation<MidiSynthesizer> synthAsync = MidiSynthesizer::CreateAsync();
        while (synthAsync.Status() == Windows::Foundation::AsyncStatus::Started)
        {
            std::this_thread::sleep_for(std::chrono::microseconds(100));
        }
        MidiSynthesizer ss = synthAsync.GetResults();

        DEBUG_TRACE(L"Microsoft Synthesizer B");

        OutputVer ver;
        ver._port = ss;
        ver._name = ss.AudioDevice().Name();
        ver._id = ss.AudioDevice().Id();
        ver._port = NULL;
        ver._nowExist = TRUE;
        ver._number = outputVector.size();
        outputVector.push_back(ver);
    }*/

    //削除されたものを閉じる
    for (OutputVer toremove : outputVector) {
        if (toremove._nowExist == FALSE) {
            //IOutClose(toremove._number);
        }
    }
}

int MXDeviceManager::OutRoomSize() {
    if (!initFlag) {
        InitObject();
    }
    return outputVector.size();
}

const wchar_t* MXDeviceManager::OutName(int device) {
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return NULL;
    }
    return outputVector[device]._name.c_str();
}
const wchar_t* MXDeviceManager::OutId(int device) {
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return NULL;
    }
    return outputVector[device]._id.c_str();
}

bool MXDeviceManager::OutIsOpen(int device) {
    wstring debug(L"OutIsOpen1 -> device=");
    debug.append(std::to_wstring(device));
    DEBUG_TRACE(debug.c_str());
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        DEBUG_TRACE(L"OutIsOpen2");
        return false;
    }
    DEBUG_TRACE(L"OutIsOpen3");
    return outputVector[device]._port != NULL;
}

bool MXDeviceManager::OutQueryOpen(int device) {
    DEBUG_TRACE(L"InReserveOpen");
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (ver._port != NULL) {
        return true;//ALREAY OPEM;
    }
    if (ver._opening == NULL) {
        ver._opening = MidiOutPort::FromIdAsync(ver._id);

    }
    return true;
}

bool MXDeviceManager::OutIsOpening(int device) {
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (ver._port != NULL) {
        return false;//ALREAY OPEM;
    }
    if (ver._opening == NULL) {
        return false;
    }
    return true;
}

bool MXDeviceManager::OutWaitDoneOpening(int device, long timeout) { //TRUE = timeout
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (OutIsOpening(device) == FALSE) {
        return false;
    }
    if (timeout == 0) {
        /*
        Canceled = 2,
        Completed = 1,
        Error = 3,
        Started = 0,
        */
        while (ver._opening.Status() == Windows::Foundation::AsyncStatus::Started)
        {
            std::this_thread::sleep_for(std::chrono::microseconds(100));
        }
    }
    else {
        while (ver._opening.Status() == Windows::Foundation::AsyncStatus::Started)
        {
            std::this_thread::sleep_for(std::chrono::microseconds(100));
            timeout -= 100;
            if (timeout < 0) {
                return true;
            }
        }
    }
    if (ver._opening.Status() == Windows::Foundation::AsyncStatus::Completed) {
        ver._port = ver._opening.GetResults();
        ver._opening = NULL;
    }
    else if (ver._opening.Status() == Windows::Foundation::AsyncStatus::Error
        || ver._opening.Status() == Windows::Foundation::AsyncStatus::Canceled) {
        ver._opening = NULL;
        ver._port = NULL;
    }
    return false;
}

bool MXDeviceManager::OutOpen(int device) {
    DEBUG_TRACE(L"OutOpen");
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (OutIsOpen(device)) {
        return true;
    }
    if (OutQueryOpen(device)) {
        OutWaitDoneOpening(device, 0);
        return OutIsOpen(device);
    }
    return false;
}

bool MXDeviceManager::OutClose(int device) {
    OutputVer& ver = outputVector[device];
    if (&ver == NULL) {
        return false;
    }
    if (outputVector[device]._port != NULL) {
        outputVector[device]._port.Close();
        outputVector[device]._port = NULL;
        return true;
    }
    return false;
}

MidiMessageType midiDataType(int status, int data1) {
    int command = status & 0xf0;
    int channel= status & 0x0f;
        
    switch (command) {
        case 0x80:
            return MidiMessageType::NoteOff;
        case 0x90:
            return MidiMessageType::NoteOn;
        case 0xa0:
            return MidiMessageType::PolyphonicKeyPressure;
        case 0xb0:
            return MidiMessageType::ControlChange;
        case 0xc0:
            return MidiMessageType::ProgramChange;
        case 0xd0:
            return MidiMessageType::ChannelPressure;
        case 0xe0:
            return MidiMessageType::PitchBendChange;
        case 0xf0: {
            switch (status) {
            case 0xf0:
                return MidiMessageType::SystemExclusive;
            case 0xf2:
                return MidiMessageType::SongPositionPointer;
            case 0xf3:
                return MidiMessageType::SongSelect;
            case 0xf4://none
                return MidiMessageType::None;
            case 0xf5://none
                return MidiMessageType::None;
            case 0xf6:
                return MidiMessageType::TuneRequest;
            case 0xf7:
                return MidiMessageType::None; //MidiMessageType::SystemExclusive;
            case 0xf8:
                return MidiMessageType::MidiTimeCode;
            case 0xf9://none
                return MidiMessageType::None;
            case 0xfa:
                return MidiMessageType::Start;
            case 0xfb:
                return MidiMessageType::Continue;
            case 0xfc:
                return MidiMessageType::Stop;
            case 0xfd: //none
                return MidiMessageType::None;
            case 0xfe:
                return MidiMessageType::ActiveSensing;
            case 0xff: //system reset
                return MidiMessageType::SystemReset;
            }
        }
    }
    return MidiMessageType::NoteOn;
}

bool MXDeviceManager::OutShortMessage(int device, int message) {
    if (OutIsOpen(device) == FALSE) {
        return false;
    }

    DEBUG_TRACE(L"OutShortMessage1");

    int status = (message >> 16) & 0xff;
    int data1 = (message >> 8) & 0xff;
    int data2 = (message) & 0xff;

    int command = status & 0xf0;
    int channel = status & 0x0f;

    switch (command) {
    case 0x80: {
            MidiNoteOffMessage msg(channel, data1, data2);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
    case 0x90: {
    DEBUG_TRACE(L"OutShortMessage1");
            MidiNoteOnMessage msg(channel, data1, data2);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
    case  0xa0: {
            MidiPolyphonicKeyPressureMessage  msg(channel, data1, data2);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
    case 0xb0: {
            MidiControlChangeMessage msg(channel, data1, data2);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
    case 0xc0: {
            MidiProgramChangeMessage msg(channel, data1);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
    case 0xd0: {
            MidiChannelPressureMessage  msg(channel, data1);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
    case 0xe0: {
            int x = ((data2 << 7) | data1);
            MidiPitchBendChangeMessage  msg(channel, x);
            outputVector[device]._port.SendMessageW(msg);
        }
        break;
        /*
    case 0xf0:  {
        switch (status) {
        case 0xf0:
            return MidiMessageType::SystemExclusive;
        case 0xf2:
            return MidiMessageType::SongPositionPointer;
        case 0xf3:
            return MidiMessageType::SongSelect;
        case 0xf4://none
            return MidiMessageType::None;
        case 0xf5://none
            return MidiMessageType::None;
        case 0xf6:
            return MidiMessageType::TuneRequest;
        case 0xf7:
            return MidiMessageType::None; //MidiMessageType::SystemExclusive;
        case 0xf8:
            return MidiMessageType::MidiTimeCode;
        case 0xf9://none
            return MidiMessageType::None;
        case 0xfa:
            return MidiMessageType::Start;
        case 0xfb:
            return MidiMessageType::Continue;
        case 0xfc:
            return MidiMessageType::Stop;
        case 0xfd: //none
            return MidiMessageType::None;
        case 0xfe:
            return MidiMessageType::ActiveSensing;
        case 0xff: //system reset
            return MidiMessageType::SystemReset;
        }
        break;
        */
    }

    return true;
}

bool MXDeviceManager::OutLongMessage(int device, jbyteArray data) {
    if (OutIsOpen(device) == FALSE) {
        return false;
    }
    
    JNIEnv* env;
    cbVM->AttachCurrentThread((void**)&env, NULL);
    int len = env->GetArrayLength(data);
    jbyte* pointer= env->GetByteArrayElements(data, NULL);
    if (len == 0) {
        return true;
    }
    if (len == 3) {
        if ((pointer[0] & 0x0f0) != 0xf0 && (pointer[0] & 0x80) == 0x80) {
            /* 0x8x --> 0xex */
            jbyte b1 = (len >= 1) ? pointer[0] : 0;
            jbyte b2 = (len >= 2) ? pointer[1] : 0;
            jbyte b3 = (len >= 3) ? pointer[2] : 0;
            int x = b1;
            x <<= 8;
            x |= b2;
            x <<= 8;
            x |= b3;
            return OutShortMessage(device, x);
        }
    }
    Buffer buf(len);
    for (int i = 0; i < len; ++i) {
        buf.data()[i] = pointer[i];
    }
    outputVector[device]._port.SendBuffer(buf);
    return true;
}

MXDeviceManager staticManger;

int receiverCnt = 0;

void receiver(MidiInPort port, IMidiMessageReceivedEventArgs args)
{
    IMidiMessage message = args.Message();

    IBuffer buf = message.RawData();
    if (buf.Length() <= 3)
    {
        uint8_t* ptr = buf.data();
        uint8_t status = (buf.Length() >= 1) ? ptr[0] : 0;
        uint8_t data1 = (buf.Length() >= 2) ? ptr[1] : 0;
        uint8_t data2 = (buf.Length() >= 3) ? ptr[2] : 0;

        uint32_t message = (((status << 8) + data1) << 8) + data2;

        refCallShortMessage(0, message);
    }
    else {
        jbyte* ptr = (jbyte*)buf.data();

        JNIEnv* env2 = NULL;
        cbVM->AttachCurrentThread((void**)&env2, NULL);
        jbyteArray jbyte = env2->NewByteArray(buf.Length());
        env2->SetByteArrayRegion(jbyte, 0, buf.Length(), ptr);
        refCallLongMessage(0, jbyte);
    }
}

extern MXDeviceManager staticManger;

//extern "C" {
typedef void(*CallText_t2)(const wchar_t* text);
typedef void(*CallShortMessage_t2)(int device, uint32_t message);
typedef void(*CallLongMessage_t2)(int device, jbyteArray data);

void refCallText(const jchar* text) {
    JNIEnv* env2 = NULL;
    cbVM->AttachCurrentThread((void**)&env2, NULL);
    jstring str = env2->NewString((uint16_t*)text, wcslen((const wchar_t*)text));
    env2->CallStaticVoidMethod(jcJNATest002, cbCallText, str);
}

void refCallShortMessage(jint device, jint message) {
    JNIEnv* env2 = NULL;
    cbVM->AttachCurrentThread((void**)&env2, NULL);
    env2->CallStaticVoidMethod(jcJNATest002, cbCallShortMessage, device, message);
}

void refCallLongMessage(jint device, const jbyteArray data) {
    JNIEnv* env2 = NULL;
    cbVM->AttachCurrentThread((void**)&env2, NULL);
    env2->CallStaticVoidMethod(jcJNATest002, cbCallLongMessage, device, data);
}

void JNICALL JNI_StartLibrary(JNIEnv* env, jobject obj)
{
    DEBUG_TRACE(L"StartLibrary");
    staticManger.InitObject();
}

int JNICALL JNI_InputDevicesRoomSize(JNIEnv* env, jobject obj)
{
    DEBUG_TRACE(L"JNI_InputDevicesRoomSize");
    return staticManger.InRoomSize();

}

jstring JNICALL JNI_InputDeviceName(JNIEnv* env, jobject obj, jint device)
{
    DEBUG_TRACE(L"JNI_InputDeviceName");
    const wchar_t* str = staticManger.InName(device);
    return env->NewString((uint16_t*)str, wcslen(str));
}

jstring JNICALL JNI_InputDeviceId(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_InputDeviceId");
    const wchar_t* str = staticManger.InId(device);
    return env->NewString((uint16_t*)str, wcslen(str));
}

boolean JNICALL JNI_InputDeviceIsOpen(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_InputDeviceIsOpen");
    return staticManger.InIsOpen(device);
}

boolean JNICALL JNI_InputDeviceOpen(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_InputDeviceOpen");
    return staticManger.InOpen(device);
}

boolean JNICALL JNI_InputDeviceQueryOpen(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_InputDeviceQueryOpen");
    return staticManger.InQueryOpen(device);
}

boolean JNICALL JNI_InputDeviceWaitDoneOpening(JNIEnv* env, jobject obj, jint  device,  jlong timeout)
{
    DEBUG_TRACE(L"JNI_InputDeviceAwaitReserved");
    return staticManger.InWaitDoneOpening(device, timeout);
}

boolean JNICALL JNI_InputDeviceClose(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_InputDeviceClose");
    return staticManger.InClose(device);
}


int JNICALL JNI_OutputDevicesRoomSize(JNIEnv* env, jobject obj)
{
    DEBUG_TRACE(L"JNI_OutputDevicesRoomSize");
    return staticManger.OutRoomSize();

}

jstring JNICALL JNI_OutputDeviceName(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_OutputDeviceName");
    const wchar_t* str = staticManger.OutName(device);
    return env->NewString((uint16_t*)str, wcslen(str));
}

jstring JNICALL JNI_OutputDeviceId(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_OutputDeviceId");
    const wchar_t* str = staticManger.OutId(device);
    return env->NewString((uint16_t*)str, wcslen(str));
}

boolean JNICALL JNI_OutputDeviceIsOpen(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_InputDeviceIsOpen");
    return staticManger.OutIsOpen(device);
}

boolean JNICALL JNI_OutputDeviceOpen(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_OutputDeviceOpen");
    return staticManger.OutOpen(device);
}

boolean JNICALL JNI_OutputDeviceQueryOpen(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_OutputDeviceQueryOpen");
    return staticManger.OutQueryOpen(device);
}

boolean JNICALL JNI_OutputDeviceWaitDoneOpening(JNIEnv* env, jobject obj, jint  device, jlong timeout)
{
    DEBUG_TRACE(L"JNI_OutputDeviceWaitDoneOpening");
    return staticManger.OutWaitDoneOpening(device, timeout);
}

boolean JNICALL JNI_OutputDeviceClose(JNIEnv* env, jobject obj, jint  device)
{
    DEBUG_TRACE(L"JNI_OutputDeviceClose");
    return staticManger.OutClose(device);
}

bool JNICALL JNI_OutputShortMessage(JNIEnv* env, jobject obj, jint  device, jint  message) {
    DEBUG_TRACE(L"JNI_OutputShortMessage");
    wstring debug(L"device=");
    debug.append(std::to_wstring(device));

    int command = (message >> 16) & 0xff;
    int data1= (message >> 8) & 0xff;
    int data2= (message) & 0xff;

    debug.append(L"  message=");
    debug.append(std::to_wstring(command));
    debug.append(L", ");
    debug.append(std::to_wstring(data1));
    debug.append(L", ");
    debug.append(std::to_wstring(data2));
    DEBUG_TRACE(debug.c_str());
    return staticManger.OutShortMessage(device, message);
}

bool JNICALL JNI_OutputLongMessage(JNIEnv* env, jobject obj, jint  port, jbyteArray data) {
    DEBUG_TRACE(L"JNI_OutputLongMessage");
    return staticManger.OutLongMessage(port, data);
}

JNIEXPORT jint JNI_OnLoad(JavaVM* vm, void* reserved) {
    JNIEnv* env;
    if (vm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION_1_1) != JNI_OK) {
        return JNI_ERR;
    }
    cbVM = vm;

    // Find your class. JNI_OnLoad is called from the correct class loader context for this to work.
    jclass c = env->FindClass("jp/synthtarou/midimixer/windows/MXLIBWindows");
    if (c == nullptr) return JNI_ERR;
    /*
        Type Signature 	Javaのデータ型
        Z 	boolean
        B 	byte
        C 	char
        S 	short
        I 	int
        J 	long
        F 	float
        D 	double
        L fully-qualified-class; 	完全修飾指定
        Ex) java.lang.String;
        [type 	配列
        Ex) int[]の場合
        [I
        (arg-types)ret-type 	メソッドの型
        Ex) void main(int argc, String[] args);
        (I[Ljava.lang.String;)V
        V 	void
    */

    // Register your class' native methods.
    static JNINativeMethod methods[] = {
        {(char*)"StartLibrary", (char*)"()V", reinterpret_cast<void*>(JNI_StartLibrary)},
        {(char*)"InputDevicesRoomSize", (char*)"()I", reinterpret_cast<void*>(JNI_InputDevicesRoomSize)},
        {(char*)"InputDeviceName", (char*)"(I)Ljava/lang/String;", reinterpret_cast<void*>(JNI_InputDeviceName)},
        {(char*)"InputDeviceId", (char*)"(I)Ljava/lang/String;", reinterpret_cast<void*>(JNI_InputDeviceId)},
        {(char*)"InputDeviceIsOpen", (char*)"(I)Z", reinterpret_cast<void*>(JNI_InputDeviceIsOpen)},
        {(char*)"InputDeviceOpen", (char*)"(I)Z", reinterpret_cast<void*>(JNI_InputDeviceOpen)},
        {(char*)"InputDeviceQueryOpen", (char*)"(I)Z", reinterpret_cast<void*>(JNI_InputDeviceQueryOpen)},
        {(char*)"InputDeviceWaitDoneOpening", (char*)"(IJ)Z", reinterpret_cast<void*>(JNI_InputDeviceWaitDoneOpening)},
        {(char*)"InputDeviceClose", (char*)"(I)Z", reinterpret_cast<void*>(JNI_InputDeviceClose)},

        {(char*)"OutputDeviceClose", (char*)"(I)Z", reinterpret_cast<void*>(JNI_OutputDeviceClose)},
        {(char*)"OutputDevicesRoomSize", (char*)"()I", reinterpret_cast<void*>(JNI_OutputDevicesRoomSize)},
        {(char*)"OutputDeviceName", (char*)"(I)Ljava/lang/String;", reinterpret_cast<void*>(JNI_OutputDeviceName)},
        {(char*)"OutputDeviceId", (char*)"(I)Ljava/lang/String;", reinterpret_cast<void*>(JNI_OutputDeviceId)},
        {(char*)"OutputDeviceIsOpen", (char*)"(I)Z", reinterpret_cast<void*>(JNI_OutputDeviceIsOpen)},
        {(char*)"OutputDeviceOpen", (char*)"(I)Z", reinterpret_cast<void*>(JNI_OutputDeviceOpen)},
        {(char*)"OutputDeviceQueryOpen", (char*)"(I)Z", reinterpret_cast<void*>(JNI_OutputDeviceQueryOpen)},
        {(char*)"OutputDeviceWaitDoneOpening", (char*)"(IJ)Z", reinterpret_cast<void*>(JNI_OutputDeviceWaitDoneOpening)},
        {(char*)"OutputDeviceClose", (char*)"(I)Z", reinterpret_cast<void*>(JNI_OutputDeviceClose)},

        {(char*)"OutputShortMessage", (char*)"(II)Z", reinterpret_cast<void*>(JNI_OutputShortMessage)},
        {(char*)"OutputLongMessage", (char*)"(I[B)Z", reinterpret_cast<void*>(JNI_OutputLongMessage)},

    };
    int rc = env->RegisterNatives(c, methods, sizeof(methods) / sizeof(JNINativeMethod));
    if (rc != JNI_OK) return rc;

    jcJNATest002 = c;
    cbCallShortMessage = env->GetStaticMethodID(jcJNATest002, "cbCallShortMessage", "(II)V");
    cbCallLongMessage = env->GetStaticMethodID(jcJNATest002, "cbCallLongMessage", "(I[B)V");
    cbCallText = env->GetStaticMethodID(jcJNATest002, "cbCallText", "(Ljava/lang/String;)V");
    //if (cbCallShortMessage == nullptr) return JNI_ERR;
    //if (cbCallText == nullptr) return JNI_ERR;
    //if (cbCallLongMessage == nullptr) return JNI_ERR;

    DEBUG_TRACE(L"Init");

    return JNI_VERSION_1_1;
}
