/*
 * Copyright 2023 yaman.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx70console;

import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX70Process implements MXSettingTarget {
    MXSetting _setting;
    MX70Panel _view;
    ConsoleModel _outsideInput = new ConsoleModel();
    ConsoleModel _insideInput = new ConsoleModel();
    ConsoleModel _insideOutput = new ConsoleModel();
    ConsoleModel _outsideOutput = new ConsoleModel();
    
    public MX70Process() {
        _setting = new MXSetting("FreeConsole");
        _setting.setTarget(this);
    }

    public void readSettings() {
        _setting.readFile();
    }

    public void createWindow() {
        if (_view != null) {
            if (_view.isOwnerWindowVisible()) { 
                return;
            }
        }
        _view = new MX70Panel(this);
        _view.showAsWindow();
    }
    
    public void addOutsideInput(ConsoleElement e) {
        _outsideInput.add(e);
        e.getTraceNumber().recordWrap(0);
    }

    public void addInsideInput(MXMessage msg) {
        ConsoleElement e = new ConsoleElement(msg._traceNumber, msg);
        _insideInput.add(e);
        e.getTraceNumber().recordWrap(1);
    }

    public void addInsideOutput(MXMessage msg) {
        ConsoleElement e = new ConsoleElement(msg._traceNumber, msg);
        _insideOutput.add(e);
        e.getTraceNumber().recordWrap(2);
    }

    public void addOutsideOutput(ConsoleElement e) {
        _outsideOutput.add(e);
        e.getTraceNumber().recordWrap(3);
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
    }
}
