/*
 * Copyright 2023 yaman.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx70console;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX70Panel extends javax.swing.JPanel {
    MX70Process _process;
    /**
     * Creates new form MX70Console
     */
    public MX70Panel(MX70Process process) {
        _process = process;
        initComponents();
        JCheckBox[] boxList = {
            jCheckBoxOutsideInput,
            jCheckBoxInsideInput,
            jCheckBoxInsideOutput,
            jCheckBoxOutsideOutput
        };
        
        for (JCheckBox box : boxList) {
            String text = box.getText();
            while(true) {
                int x = text.indexOf('/');
                if (x >= 0) {
                    String front = text.substring(0, x);
                    String back = text.substring(x + 1);
                    text = front + "<br>" + back;
                }else 
                {
                    break;
                }
            }
            box.setText("<html>" + text + "</html>");
            box.setSelected(true);
        }

        Dimension size = getSize();
        size.width /= 4;
        size.width -= 4;
        size.height -= 4;

        jScrollPane2.setPreferredSize(size);
        jScrollPane3.setPreferredSize(size);
        jScrollPane4.setPreferredSize(size);
        jScrollPane5.setPreferredSize(size);

        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                _process._outsideInput.bind(jListOutsideInput);
                _process._insideInput.bind(jListInsideInput);
                _process._insideOutput.bind(jListInsideOutput);
                _process._outsideOutput.bind(jListOutsideOutput);
                showTimeSpend();
            }
        });
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBoxOutsideInput = new javax.swing.JCheckBox();
        jCheckBoxInsideInput = new javax.swing.JCheckBox();
        jCheckBoxInsideOutput = new javax.swing.JCheckBox();
        jCheckBoxOutsideOutput = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        jPanelOutsideInput = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jListOutsideInput = new javax.swing.JList<>();
        jPanelInsideInput = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jListInsideInput = new javax.swing.JList<>();
        jPanelInsideOutput = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        jListInsideOutput = new javax.swing.JList<>();
        jPanelOutsideOutput = new javax.swing.JPanel();
        jScrollPane5 = new javax.swing.JScrollPane();
        jListOutsideOutput = new javax.swing.JList<>();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabelOutsideInput = new javax.swing.JLabel();
        jLabelInsideInput = new javax.swing.JLabel();
        jLabelInsideOutput = new javax.swing.JLabel();
        jLabelOutsideOutput = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        jCheckBoxOutsideInput.setText("Outside/Input");
        jCheckBoxOutsideInput.setToolTipText("");
        jCheckBoxOutsideInput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxOutsideInputActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        add(jCheckBoxOutsideInput, gridBagConstraints);

        jCheckBoxInsideInput.setText("Inside/Input");
        jCheckBoxInsideInput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxInsideInputActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        add(jCheckBoxInsideInput, gridBagConstraints);

        jCheckBoxInsideOutput.setText("Inside/Output");
        jCheckBoxInsideOutput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxInsideOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        add(jCheckBoxInsideOutput, gridBagConstraints);

        jCheckBoxOutsideOutput.setText("Outsize/Output");
        jCheckBoxOutsideOutput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxOutsideOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        add(jCheckBoxOutsideOutput, gridBagConstraints);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.LINE_AXIS));

        jPanelOutsideInput.setBorder(javax.swing.BorderFactory.createTitledBorder("Outside Input"));
        jPanelOutsideInput.setLayout(new javax.swing.BoxLayout(jPanelOutsideInput, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane2.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jListOutsideInput.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jListOutsideInputMousePressed(evt);
            }
        });
        jListOutsideInput.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListOutsideInputValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(jListOutsideInput);

        jPanelOutsideInput.add(jScrollPane2);

        jPanel1.add(jPanelOutsideInput);

        jPanelInsideInput.setBorder(javax.swing.BorderFactory.createTitledBorder("Inide Input"));
        jPanelInsideInput.setLayout(new javax.swing.BoxLayout(jPanelInsideInput, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane3.setToolTipText("");
        jScrollPane3.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jListInsideInput.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jListInsideInputMousePressed(evt);
            }
        });
        jListInsideInput.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListInsideInputValueChanged(evt);
            }
        });
        jScrollPane3.setViewportView(jListInsideInput);

        jPanelInsideInput.add(jScrollPane3);

        jPanel1.add(jPanelInsideInput);

        jPanelInsideOutput.setBorder(javax.swing.BorderFactory.createTitledBorder("Inside Output"));
        jPanelInsideOutput.setLayout(new javax.swing.BoxLayout(jPanelInsideOutput, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane4.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jListInsideOutput.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jListInsideOutputMousePressed(evt);
            }
        });
        jListInsideOutput.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListInsideOutputValueChanged(evt);
            }
        });
        jScrollPane4.setViewportView(jListInsideOutput);

        jPanelInsideOutput.add(jScrollPane4);

        jPanel1.add(jPanelInsideOutput);

        jPanelOutsideOutput.setBorder(javax.swing.BorderFactory.createTitledBorder("Outsde Output"));
        jPanelOutsideOutput.setLayout(new javax.swing.BoxLayout(jPanelOutsideOutput, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane5.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jListOutsideOutput.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jListOutsideOutputMousePressed(evt);
            }
        });
        jListOutsideOutput.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListOutsideOutputValueChanged(evt);
            }
        });
        jScrollPane5.setViewportView(jListOutsideOutput);

        jPanelOutsideOutput.add(jScrollPane5);

        jPanel1.add(jPanelOutsideOutput);

        jScrollPane1.setViewportView(jPanel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("jLabel1");
        jPanel2.add(jLabel1, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel2, gridBagConstraints);

        jLabelOutsideInput.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        add(jLabelOutsideInput, gridBagConstraints);

        jLabelInsideInput.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        add(jLabelInsideInput, gridBagConstraints);

        jLabelInsideOutput.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        add(jLabelInsideOutput, gridBagConstraints);

        jLabelOutsideOutput.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        add(jLabelOutsideOutput, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxOutsideInputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxOutsideInputActionPerformed
        jPanelOutsideInput.setVisible(jCheckBoxOutsideInput.isSelected());
    }//GEN-LAST:event_jCheckBoxOutsideInputActionPerformed

    private void jCheckBoxInsideInputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxInsideInputActionPerformed
        jPanelInsideInput.setVisible(jCheckBoxInsideInput.isSelected());
    }//GEN-LAST:event_jCheckBoxInsideInputActionPerformed

    private void jCheckBoxInsideOutputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxInsideOutputActionPerformed
        jPanelInsideOutput.setVisible(jCheckBoxInsideOutput.isSelected());
    }//GEN-LAST:event_jCheckBoxInsideOutputActionPerformed

    private void jCheckBoxOutsideOutputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxOutsideOutputActionPerformed
        jPanelOutsideOutput.setVisible(jCheckBoxOutsideOutput.isSelected());
    }//GEN-LAST:event_jCheckBoxOutsideOutputActionPerformed
    
    public void selectByTraceNumberCall(JList list, MXTraceNumber trace)  {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                selectByTraceNumber(list, trace);
            }
        });
    }
    
    public void selectByTraceNumber(JList list, MXTraceNumber trace) 
    {
        _process._outsideInput.setSelectedTraceNumber(trace);
        _process._insideInput.setSelectedTraceNumber(trace);
        _process._insideOutput.setSelectedTraceNumber(trace);
        _process._outsideOutput.setSelectedTraceNumber(trace);
    }
    
    private void jListOutsideInputValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListOutsideInputValueChanged
        int index = jListOutsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._outsideInput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListOutsideInput, e.getTraceNumber());
                jLabel1.setText("" + e.getTraceNumber() + " => "
                        + "0 = " + e.getTraceNumber().thisWrap(0) + ", "
                        + "1 = " + e.getTraceNumber().thisWrap(1) + ", "
                        + "2 = " + e.getTraceNumber().thisWrap(2) + ", "
                        + "3 = =" + e.getTraceNumber().thisWrap(3)
                );
            }
        }
    }//GEN-LAST:event_jListOutsideInputValueChanged

    private void jListInsideInputValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListInsideInputValueChanged
        int index = jListInsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._insideInput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListInsideInput, e.getTraceNumber());
                jLabel1.setText("" + e.getTraceNumber() + " => " 
                        + "0 = " + e.getTraceNumber().thisWrap(0) + ", "
                        + "1 = " + e.getTraceNumber().thisWrap(1) + ", "
                        + "2 = " + e.getTraceNumber().thisWrap(2) + ", "
                        + "3 = =" + e.getTraceNumber().thisWrap(3) 
                );
            }
        }
    }//GEN-LAST:event_jListInsideInputValueChanged

    private void jListInsideOutputValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListInsideOutputValueChanged
        int index = jListInsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._insideOutput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListInsideOutput, e.getTraceNumber());
                jLabel1.setText("" + e.getTraceNumber() + " => " 
                        + "0 = " + e.getTraceNumber().thisWrap(0) + ", "
                        + "1 = " + e.getTraceNumber().thisWrap(1) + ", "
                        + "2 = " + e.getTraceNumber().thisWrap(2) + ", "
                        + "3 = =" + e.getTraceNumber().thisWrap(3) 
                );                
            }
        }
    }//GEN-LAST:event_jListInsideOutputValueChanged

    private void jListOutsideOutputValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListOutsideOutputValueChanged
        int index = jListOutsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._outsideOutput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListOutsideOutput, e.getTraceNumber());
                jLabel1.setText("" + e.getTraceNumber() + " => " 
                        + "0 = " + e.getTraceNumber().thisWrap(0) + ", "
                        + "1 = " + e.getTraceNumber().thisWrap(1) + ", "
                        + "2 = " + e.getTraceNumber().thisWrap(2) + ", "
                        + "3 = =" + e.getTraceNumber().thisWrap(3) 
                );
            }
        }
    }//GEN-LAST:event_jListOutsideOutputValueChanged

    private void jListOutsideInputMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListOutsideInputMousePressed
        int index = jListOutsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._outsideInput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListOutsideInput, e.getTraceNumber());
            }
        }
    }//GEN-LAST:event_jListOutsideInputMousePressed

    private void jListInsideInputMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListInsideInputMousePressed
int index = jListInsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._insideInput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListInsideInput, e.getTraceNumber());
            }
        }
    }//GEN-LAST:event_jListInsideInputMousePressed

    private void jListInsideOutputMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListInsideOutputMousePressed
        int index = jListInsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._insideOutput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListInsideOutput, e.getTraceNumber());
            }
        }
    }//GEN-LAST:event_jListInsideOutputMousePressed

    private void jListOutsideOutputMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListOutsideOutputMousePressed
        int index = jListOutsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = _process._outsideOutput.getConsoleElement(index);
            if (e != null) {
                selectByTraceNumberCall(jListOutsideOutput, e.getTraceNumber());
            }
        }
    }//GEN-LAST:event_jListOutsideOutputMousePressed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxInsideInput;
    private javax.swing.JCheckBox jCheckBoxInsideOutput;
    private javax.swing.JCheckBox jCheckBoxOutsideInput;
    private javax.swing.JCheckBox jCheckBoxOutsideOutput;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelInsideInput;
    private javax.swing.JLabel jLabelInsideOutput;
    private javax.swing.JLabel jLabelOutsideInput;
    private javax.swing.JLabel jLabelOutsideOutput;
    private javax.swing.JList<String> jListInsideInput;
    private javax.swing.JList<String> jListInsideOutput;
    private javax.swing.JList<String> jListOutsideInput;
    private javax.swing.JList<String> jListOutsideOutput;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelInsideInput;
    private javax.swing.JPanel jPanelInsideOutput;
    private javax.swing.JPanel jPanelOutsideInput;
    private javax.swing.JPanel jPanelOutsideOutput;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    // End of variables declaration//GEN-END:variables

    public boolean isOwnerWindowVisible() {
        try {
            Container cont = MXUtil.getOwnerWindow(this);
            if (cont.isVisible()) {
                return true;
            }
            return false;
        }catch(Exception e) {
            e.printStackTrace();
        }
        return false;
    }
    
    NumberFormat formatter3 = new DecimalFormat("0.000");  

    public void showTimeSpend() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    for (int i = 0; i < 4; ++ i) {
                        long count = MXTraceNumber.totalCount(i);
                        long spend = MXTraceNumber.totalWrap(i);
                        long bottom = MXTraceNumber.totalBottom(i);

                        String div = formatter3.format(1.0 * spend/ count);

                        String text = "<html>" + spend + "ms/" + count + "=" + div +"<br> bottom" + bottom+"ms</html>";
                        switch(i) {
                            case 0: jLabelOutsideInput.setText(text);break;
                            case 1: jLabelInsideInput.setText(text);break;
                            case 2: jLabelInsideOutput.setText(text);break;
                            case 3: jLabelOutsideOutput.setText(text);break;
                        }
                    }
                }catch(Throwable e) {
                    e.printStackTrace();
                }
                Container parent = getParent();
                while (parent != null) {
                    if (parent instanceof Window) {
                        Window w = (Window)parent;
                        if (w.isVisible() == false) {
                            return;
                        }
                    }
                    if (parent instanceof Dialog) {
                        Dialog d = (Dialog)parent;
                        if (d.isVisible() == false) {
                            return;
                        }
                    }
                    parent = parent.getParent();
                }
                MXTimer.letsCountdown(1000, new Runnable() {
                    public void run() {
                        showTimeSpend();
                    }
                });
            }
        });
    }

    public void showAsWindow() {
        JFrame newFrame = new JFrame();
        newFrame.setTitle("Free Consone / SysEX(" + MXStatic.MX_APPNAME + ")");
        //dialog.setAlwaysOnTop(modal ? true : false);
        newFrame.pack();
        newFrame.getContentPane().add(this);
        setPreferredSize(new Dimension(1000, 250));
        newFrame.pack();
        MXUtil.centerWindow(newFrame);
        newFrame.setVisible(true);

        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                int count = ConsoleModel._capacity - 1;
                jListOutsideInput.ensureIndexIsVisible(count);
                jListInsideInput.ensureIndexIsVisible(count);
                jListInsideOutput.ensureIndexIsVisible(count);
                jListOutsideOutput.ensureIndexIsVisible(count);
            }
        });
    }
}
