/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx60output;

import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX60View extends javax.swing.JPanel {
    MX60Process _process;
    private static final MXDebugLines _debug = new MXDebugLines(MX60View.class);
    JTableWithColumnHeader _jTableSkip;
    boolean _useSkipCC = true;
    MXWrapList<Integer> _recPortList;
    
    /**
     * Creates new form MX50
     */
    public MX60View(MX60Process process) {
        _process = process; 
        initComponents();

        jPanelOutputSelect.add(new MX60MidiOutListPanel());
        
        //_recPortList = MXUtilMidi.createPort(false);
        //jComboBoxRecSong.setModel(_recPortList);
         
        _jTableSkip = new JTableWithFooter(jPanel1);
        resetTableModel();
        _jTableSkip.addMouseListener(new java.awt.event.MouseAdapter() {
            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                if (_jTableSkip.isEnabled()) {
                    jTableSkip_MouseClicked(evt);
                }
            }
        });
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(JLabel.CENTER);

        for (int i = 1; i < _jTableSkip.getColumnCount(); ++ i) {
            TableColumn col = _jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        jCheckBoxUseSkip.setSelected(_process.isUsingThisRecipe());
        _jTableSkip.setEnabled(_process.isUsingThisRecipe());
        jPanel2.add(_process.getPatchBay().getReceiverView());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane2 = new javax.swing.JSplitPane();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelOutputSelect = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jCheckBoxUseSkip = new javax.swing.JCheckBox();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jSplitPane2.setDividerLocation(250);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jSplitPane1.setDividerLocation(300);

        jPanelOutputSelect.setBorder(javax.swing.BorderFactory.createTitledBorder("1.Assign Output"));
        jPanelOutputSelect.setLayout(new javax.swing.BoxLayout(jPanelOutputSelect, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setLeftComponent(jPanelOutputSelect);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("2. Port Forwarding"));
        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setBottomComponent(jPanel2);

        jSplitPane2.setTopComponent(jSplitPane1);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("3.Skip Which"));
        jPanel3.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel1, gridBagConstraints);

        jCheckBoxUseSkip.setText("Use This Recipe");
        jCheckBoxUseSkip.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel3.add(jCheckBoxUseSkip, gridBagConstraints);

        jSplitPane2.setRightComponent(jPanel3);

        add(jSplitPane2);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseSkipActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseSkipActionPerformed
         _process.setUsingThisRecipe(jCheckBoxUseSkip.isSelected());
        _jTableSkip.setEnabled(jCheckBoxUseSkip.isSelected());
    }//GEN-LAST:event_jCheckBoxUseSkipActionPerformed

    public synchronized TableModel createSkipTableModel() {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        model.addColumn("");
        
        for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
            model.addColumn(MXUtilMidi.nameOfPortShort(i));
        }
        
        for (int row = 0; row < _process._data.TYPE_COUNT; ++ row) {
            Vector line = new Vector();
            line.add(_process._data.typeNames[row]);
            
            for (int delivery = 0; delivery < MXStatic.TOTAL_PORT_COUNT; ++ delivery) {
                int type = row + 1;
                if (_process._data.isSkip(delivery, type)) {
                    line.add("Skip");
                }else {
                    line.add("");
                }
            }
            model.addRow(line);
        }
        return model;

    }

    private void jTableSkip_MouseClicked(java.awt.event.MouseEvent evt) {                                     
        int row = _jTableSkip.rowAtPoint(evt.getPoint());
        int column = _jTableSkip.columnAtPoint(evt.getPoint());
        
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)_jTableSkip.getModel();
        
        if (type >= 1 && type <= _process._data.TYPE_COUNT) {
            if (port >= 0 && port < MXStatic.TOTAL_PORT_COUNT) {
                if (_process._data.isSkip(port, type)) {
                    _process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                }else {
                    _process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }                                    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxUseSkip;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanelOutputSelect;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    // End of variables declaration//GEN-END:variables

    public void resetTableModel() {
        _jTableSkip.setModel(createSkipTableModel());
        _jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }
}
