/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx30controller;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MGPad extends javax.swing.JPanel implements MXFocusAble {
    private static final MXDebugLines _debug = new MXDebugLines(MGPad.class);
    final MX32MixerProcess _process;
    int _row, _column;
    boolean _dispFlag;
    
    Color highlight = MXUtil.mixedColor(Color.white, Color.blue, 50);
    
    class MyButtonUI extends BasicButtonUI {
        public MyButtonUI() {
        }
        
        public void paint(Graphics g, JComponent c) {
            MGStatus status = getStatus();
            boolean sel = _dispFlag;

            if (sel) {
                Dimension d = c.getSize();
                g.setColor(highlight);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }else {
                super.paint(g, c);
            }
        }
    }
    
    public MGStatus getStatus() {
        return _process._data.getDrumPadStatus(_row, _column);
    }

    public void setStatus(MGStatus status) {
        _process._data.setDrumPadStatus(_row, _column, status);
    }

    public MGPad(MX32MixerProcess process, int row, int column) {
        _process = process;
        _row = row;
        _column = column;
        initComponents();
        jButton1.setText(" ");
        for (MouseListener l : jButton1.getMouseListeners()) {
            jButton1.removeMouseListener(l);
        }
        jButton1.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e)  {
                if(SwingUtilities.isRightMouseButton(e)){
                   return;
                }
                _process.catchedValueDrum(getStatus(), new MXTraceNumber(),  true, getStatus().getSwitchOutOnValueFixed(), null);
            }
            
            public void mouseReleased(MouseEvent e)  {
                if(SwingUtilities.isRightMouseButton(e)){
                    return;
                }
                _process.catchedValueDrum(getStatus(), new MXTraceNumber(), false, 0, null);
            }
        });
        
        jButton1.setUI(new MyButtonUI());

        //jSpinnerValue.setVisible(false);

        updateUI();
    }
    
    public void updateUIOnly(boolean newValue) {
        _dispFlag = newValue;
        jButton1.repaint();
    }

    public void updateUI() {
        if (_process != null && _process != null) {
            MGStatus status = getStatus();
            
            status.fixRangedValue();

            if (status.getName() == null || status.getName().length() == 0) {
                MXMessage message = status.toMXMessage(new MXTraceNumber());
                if (message == null) {
                    jLabel1.setText("?");
                }else {
                    jLabel1.setText(message.toShortString());
                }
            }else {
                jLabel1.setText(status.getName());
            }
        }
        super.updateUI();
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jLabel1, gridBagConstraints);

        jButton1.setText("-");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jButton1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    }//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag) {
            if (_process != null) {
                MGStatus status = getStatus();
                _process._parent.showTextForFocus(MGStatus.TYPE_DRUMPAD, _process._port, _row, _column);
            }
        }
    }
    
    public void setValueChangeable(boolean using) {
        jButton1.setEnabled(using);
    }
    
    @Override
    public void focusedMousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || _process._parent._editingControl) {
            _process._parent.enterEditMode(false);
            focusStatusChanged(false);
            editContoller();
         }
    }

    @Override
    public void focusChangingValue() {
        _process._parent.showTextForFocus(MGStatus.TYPE_DRUMPAD,  _process._port, _row, _column);
    }

    public void increment(DoubleCheck already, MXTraceNumber traceNumber) {
        _process.catchedValueDrum(getStatus(), traceNumber, true, getStatus().getSwitchOutOnValueFixed(), null);
    }
    
    public void decriment(DoubleCheck already, MXTraceNumber traceNumber) { 
        _process.catchedValueDrum(getStatus(), traceNumber, false, 0, null);
    }

   public void editContoller() {
        _process._parent.enterEditMode(false);
        MGStatusConfig config = new MGStatusConfig(_process, getStatus());
        MXUtil.showAsDialog(this, config, "Enter Edit Pad {row:" + _row + ", column:" + _column + "}");
        _process.notifyCacheBroken();

        if (config._okOption) {
            setStatus(config._status);
            _process.notifyCacheBroken();
            updateUI();
        }
    }
}
