/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx30controller;

import jp.synthtarou.midimixer.libs.MXUtil;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class InitializeConfirmPanel extends javax.swing.JPanel {
    MX32MixerProcess _process;
    /**
     * Creates new form InitializeConfirmPanel2
     */
    public InitializeConfirmPanel(MX32MixerProcess process) {
        _process = process;
        initComponents();
        buttonGroup1.add(jRadioButtonMixer);
        buttonGroup1.add(jRadioButtonDAW);
        buttonGroup1.add(jRadioButtonGMTone);
        jRadioButtonGMTone.setVisible(false);
        buttonGroup1.add(jRadioButtonSound);
        buttonGroup1.add(jRadioButtonInit);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        jRadioButtonMixer = new javax.swing.JRadioButton();
        jRadioButtonDAW = new javax.swing.JRadioButton();
        jRadioButtonSound = new javax.swing.JRadioButton();
        jButton1 = new javax.swing.JButton();
        jRadioButtonInit = new javax.swing.JRadioButton();
        jRadioButtonGMTone = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Which way ?");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel1, gridBagConstraints);

        jRadioButtonMixer.setSelected(true);
        jRadioButtonMixer.setText("Mixer");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButtonMixer, gridBagConstraints);

        jRadioButtonDAW.setText("DAW");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButtonDAW, gridBagConstraints);

        jRadioButtonSound.setText("Sound");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButtonSound, gridBagConstraints);

        jButton1.setText("Initialize");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jButton1, gridBagConstraints);

        jRadioButtonInit.setText("Init");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButtonInit, gridBagConstraints);

        jRadioButtonGMTone.setText("GMTone");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButtonGMTone, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        boolean ret = false;
        if (jRadioButtonMixer.isSelected()) {
            ret = _process._data.initializeData(MX32MixerData.INIT_TYPE_MIXER);
        }
        if (jRadioButtonDAW.isSelected()) {
            ret = _process._data.initializeData(MX32MixerData.INIT_TYPE_DAW);
        }
        if (jRadioButtonGMTone.isSelected()) {
            ret = _process._data.initializeData(MX32MixerData.INIT_TYPE_GMTOME);
        }
        if (jRadioButtonSound.isSelected()) {
            ret = _process._data.initializeData(MX32MixerData.INIT_TYPE_SOUDMODULE);
        }
        if (jRadioButtonInit.isSelected()) {
            ret = _process._data.initializeData(MX32MixerData.INIT_TYPE_ZERO);
        }
        if (ret) {
            _process._view.initControllers();
            MXUtil.closeOwnerWindow(this);
        }
    }//GEN-LAST:event_jButton1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton jRadioButtonDAW;
    private javax.swing.JRadioButton jRadioButtonGMTone;
    private javax.swing.JRadioButton jRadioButtonInit;
    private javax.swing.JRadioButton jRadioButtonMixer;
    private javax.swing.JRadioButton jRadioButtonSound;
    // End of variables declaration//GEN-END:variables
}
