/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.util.Comparator;
import java.util.TreeSet;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMidi;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class DoubleCheck {
    TreeSet<MGStatus> _alreadyStatus = new TreeSet(new StatusComparator());
    
    static class StatusComparator implements Comparator<MGStatus> {
        @Override
        public int compare(MGStatus o1, MGStatus o2) {
            int p = o1.getPort() - o2.getPort();
            if (p < 0) return -1;
            if (p > 0) return 1;
            
            int z = o1.getUiType() - o2.getUiType();
            if (z < 0) return -1;
            if (z > 0) return 1;

            int y = o1.getRow() - o2.getRow();
            if (y < 0) return -1;
            if (y > 0) return 1;

            int x = o1.getColumn() - o2.getColumn();
            if (x < 0) return -1;
            if (x > 0) return 1;

            return 0;
        }
    }
    
    TreeSet<MXMessage> _alreadyMessage = new TreeSet(new MessageComparator());
    
    static class MessageComparator implements Comparator<MXMessage> {

        @Override
        public int compare(MXMessage o1, MXMessage o2) {
            if (o1.isDataentry()) {
                if (o2.isDataentry() == false) {
                    return -1;
                }
                MXVisitant v1 = o1.getVisitant();
                MXVisitant v2 = o2.getVisitant();
                int x;
                x = v1.getDataroomType() - v2.getDataroomType();
                if (x == 0) { x = v1.getDataroomMSB() - v2.getDataroomMSB(); }
                if (x == 0) { x = v1.getDataroomLSB() - v2.getDataroomLSB(); }
                if (x == 0) { x = v1.getDataentryMSB()- v2.getDataentryMSB(); }
                if (x == 0) { x = v1.getDataentryLSB() - v2.getDataentryLSB(); }
                if (x == 0) { x = v1.getDataentryValue14() - v2.getDataentryValue14(); }
                return x;
            }else if (o2.isDataentry()) {
                return 1;
            }
            
            byte[] t1 = o1.getDataBytes();
            byte[] t2 = o2.getDataBytes();
            
            if (t1 == null) {
                if (t2 == null) {
                    return 0;
                }
                return  -1;
            }
            if (t2 == null) {
                return 1;
            }            

            int x = t1.length - t2.length;
            
            if (x < 0) return -1;
            if (x > 0) return 1;

            for (int i = 0; i < t1.length; ++ i) {
                x = t1[i] - t2[i];
                if (x < 0) return -1;
                if (x > 0) return 1;
            }
            /*
            x = o1.getPort() - o2.getPort();
            if (x < 0) return -1;
            if (x > 0) return 1;

            x = o1.getStatus()- o2.getStatus();
            if (x < 0) return -1;
            if (x > 0) return 1;

            x = o1.getGate()- o2.getGate();
            if (x < 0) return -1;
            if (x > 0) return 1;

            x = o1.getValue()- o2.getValue();
            if (x < 0) return -1;
            if (x > 0) return 1;
            */
            return 0;
        }
    }
    
    final MXReceiver _receiver;
    
    public DoubleCheck(MXReceiver receiver) {
        _receiver = receiver;
    }
    
    public boolean checkAlready(MGStatus status) {
        return _alreadyStatus.contains(status);
    }
    
    public void push(MGStatus status) {
        _alreadyStatus.add(status);
    }
    
    public boolean sendOnlyNeed(MXMessage message) {
        if (message.getCommand() == MXMidi.COMMAND_NOTEON && message.getValue() == 0) {
            message = MXMessageFactory.fromShortMessage(message.getPort(), message._traceNumber, MXMidi.COMMAND_NOTEOFF + message.getChannel(), message.getGate(), 0);
        }
        if (_receiver == null) {
            //panel is under construction
            return false;
        }
        if (_alreadyMessage.contains(message)) {
            return false;
        }
        _alreadyMessage.add(message);
        _receiver.processMXMessage(message);
        return true;
    }
}
