/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx11vcurve;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.SafeSpinnerNumberModel;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX11View extends javax.swing.JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX11View.class);
    /**
     * Creates new form MXMidiChannelPanel
     */
    JTableWithFooter jTableVelocity;
    
    MX11Process _process;
    
    public MX11View(MX11Process process) {
        _process = process;

        initComponents();
        setMinimumSize(new Dimension(100, 100));

        jTableVelocity = new JTableWithFooter(jPanelChannelMapping);
        jTableVelocity.setModel(createTableModel());
        
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(JLabel.CENTER);

        for (int i = 1; i < jTableVelocity.getColumnCount(); ++ i) {
            TableColumn col = jTableVelocity.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }

        jCheckBoxUseRoute.setSelected(_process.isUsingThisRecipe());
        jTableVelocity.setEnabled(_process.isUsingThisRecipe());

        jLabelVelocityPort.setText("-");
        jLabelVelocityOriginal.setText("-");

        jTableVelocity.addMouseListener(new MouseAdapter() { 
            public void mousePressed(MouseEvent e) {
                jTableVelocity_MouseClicked(e);
            }
        });
   }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBoxUseRoute = new javax.swing.JCheckBox();
        jPanelChannelMapping = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jSpinnerVelocityCurve = new javax.swing.JSpinner();
        jLabelVelocityPort = new javax.swing.JLabel();
        jLabelVelocityOriginal = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jCheckBoxUseRoute.setText("Use This Recipe");
        jCheckBoxUseRoute.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(jCheckBoxUseRoute, gridBagConstraints);

        jPanelChannelMapping.setBorder(javax.swing.BorderFactory.createTitledBorder("Curve / Port"));
        jPanelChannelMapping.setLayout(new javax.swing.BoxLayout(jPanelChannelMapping, javax.swing.BoxLayout.LINE_AXIS));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanelChannelMapping, gridBagConstraints);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Edit"));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Original");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel2, gridBagConstraints);

        jLabel3.setText("To");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jLabel3, gridBagConstraints);

        jButton1.setText("Apply");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jButton1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jSpinnerVelocityCurve, gridBagConstraints);

        jLabelVelocityPort.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jLabelVelocityPort, gridBagConstraints);

        jLabelVelocityOriginal.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jLabelVelocityOriginal, gridBagConstraints);

        jLabel4.setText("   ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 2.0;
        jPanel1.add(jLabel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel3, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseRouteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseRouteActionPerformed
        _process.setUsingThisRecipe(jCheckBoxUseRoute.isSelected());
        jTableVelocity.setEnabled(jCheckBoxUseRoute.isSelected());
    }//GEN-LAST:event_jCheckBoxUseRouteActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        MX11Data data = _process.getData();
        DefaultTableModel model = (DefaultTableModel)jTableVelocity.getModel();
        int port = jLabelVelocityPort.getText().charAt(0) - 'A';
        int velocityOrg = Integer.parseInt(jLabelVelocityOriginal.getText());
        int velocity = (int)jSpinnerVelocityCurve.getValue();
        
        for (int i = 0; i < data.curveCount(); i ++) {
            if (data.curveDefault(i) == velocityOrg) {
                data.setCurveValue(port, i, velocity);
                model.setValueAt(velocity, model.getRowCount() - 1 - i, port  + 1);
            }
        }

        jTableVelocity.repaint();
        //jTableVelocity.setModel(createTableModel());
    }//GEN-LAST:event_jButton1ActionPerformed
  
    public synchronized TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        String inName = "";
        String outName = "";
        MX11Data data = _process.getData();

        model.addColumn("");
        
        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            model.addColumn(outName + MXUtilMidi.nameOfPortInput(port));
        }
        
        for (int i = data.curveCount() - 1; i >= 0; --i) {
            Vector line = new Vector();
            line.add(inName + data.curveDefault(i));
            for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
                line.add(data.curveValue(port, i));
            }
            model.addRow(line);
        }
        return model;
    }
    
    public void jTableVelocity_MouseClicked(MouseEvent evt)
    {
        int row = jTableVelocity.rowAtPoint(evt.getPoint());
        int column = jTableVelocity.columnAtPoint(evt.getPoint());
            
        column --;

        if (column >= 0) {         
            try {
                MX11Data data = _process.getData();
                int curveId = data.curveCount() - 1 - row;
                int port = column;
                
                int base = data.curveDefault(curveId);
                int set = data.curveValue(port, curveId);

                jLabelVelocityPort.setText(MXUtilMidi.nameOfPortInput(port));
                jLabelVelocityOriginal.setText(String.valueOf(base));
                jSpinnerVelocityCurve.setModel(new SafeSpinnerNumberModel(set, 0, 127, 1));
            }catch(Throwable e) {
                e.printStackTrace();
            }   
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JCheckBox jCheckBoxUseRoute;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabelVelocityOriginal;
    private javax.swing.JLabel jLabelVelocityPort;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanelChannelMapping;
    private javax.swing.JSpinner jSpinnerVelocityCurve;
    // End of variables declaration//GEN-END:variables
}
