/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx10input;

import java.util.Vector;
import javax.swing.JLabel;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX10View extends javax.swing.JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX10View.class);
    MX10Process _process;
    MX10MidiInListPanel _inPanel;
    JTableWithColumnHeader _jTableSkip;
    
    /**
     * Creates new form MX10
     */
    public MX10View(MX10Process process) {
        _process = process; 
        initComponents();

        _inPanel = new MX10MidiInListPanel();
        jPanelInputSelect.add(_inPanel);

        _jTableSkip = new JTableWithFooter(jPanel1);
        resetTableModel();
        _jTableSkip.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                if (_jTableSkip.isEnabled()) {
                    jTableSkip_MouseClicked(evt);
                }
            }
        });

        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(JLabel.CENTER);

        for (int i = 1; i < _jTableSkip.getColumnCount(); ++ i) {
            TableColumn col = _jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        
        jCheckBoxUseMessageFilter.setSelected(_process.isUseMessageFilter());

        _jTableSkip.setEnabled(_process.isUseMessageFilter());
        jPanel4.add(_process._patchBay.getReceiverView());
    }
    
    private void jTableSkip_MouseClicked(java.awt.event.MouseEvent evt) {                                     
        int row = _jTableSkip.rowAtPoint(evt.getPoint());
        int column = _jTableSkip.columnAtPoint(evt.getPoint());
        
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)_jTableSkip.getModel();
        
        if (type >= 1 && type <= _process._data.TYPE_COUNT) {
            if (port >= 0 && port < MXStatic.TOTAL_PORT_COUNT) {
                if (_process._data.isSkip(port, type)) {
                    _process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                }else {
                    _process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }                                    

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane2 = new javax.swing.JSplitPane();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelInputSelect = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jPanelSkip = new javax.swing.JPanel();
        jCheckBoxUseMessageFilter = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jSplitPane2.setDividerLocation(240);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jSplitPane1.setDividerLocation(400);

        jPanelInputSelect.setBorder(javax.swing.BorderFactory.createTitledBorder("1.Assign Input"));
        jPanelInputSelect.setLayout(new javax.swing.BoxLayout(jPanelInputSelect, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setLeftComponent(jPanelInputSelect);

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("2.Port Forwarding"));
        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setBottomComponent(jPanel4);

        jSplitPane2.setLeftComponent(jSplitPane1);

        jPanelSkip.setBorder(javax.swing.BorderFactory.createTitledBorder("3.Skip Which"));
        jPanelSkip.setLayout(new java.awt.GridBagLayout());

        jCheckBoxUseMessageFilter.setText("Use This Recipe");
        jCheckBoxUseMessageFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseMessageFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelSkip.add(jCheckBoxUseMessageFilter, gridBagConstraints);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.LINE_AXIS));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelSkip.add(jPanel1, gridBagConstraints);

        jSplitPane2.setRightComponent(jPanelSkip);

        add(jSplitPane2);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseMessageFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseMessageFilterActionPerformed
        _process.setUseMesssageFilter(jCheckBoxUseMessageFilter.isSelected());
    }//GEN-LAST:event_jCheckBoxUseMessageFilterActionPerformed

    public synchronized TableModel createSkipTableModel(MX10Data data) {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        model.addColumn("");
        
        for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
            model.addColumn(MXUtilMidi.nameOfPortShort(i));
        }
        
        for (int row = 0; row < _process._data.TYPE_COUNT; ++ row) {
            Vector line = new Vector();
            line.add(data.typeNames[row]);
            
            for (int delivery = 0; delivery < MXStatic.TOTAL_PORT_COUNT; ++ delivery) {
                int type = row + 1; /* 1 ... 9 */
                if (data.isSkip(delivery, type)) {
                    line.add("Skip");
                }else {
                    line.add("");
                }
            }
            model.addRow(line);
        }
        if (true) {
            Vector line = new Vector();
            line.add("");

            for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
                line.add(MXUtilMidi.nameOfPortShort(i));
            }
        }
        return model;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxUseMessageFilter;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelInputSelect;
    private javax.swing.JPanel jPanelSkip;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    // End of variables declaration//GEN-END:variables

    public void resetTableModel() {
        _jTableSkip.setModel(createSkipTableModel(_process._data));
        _jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }
}
