/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.awt.Dimension;
import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;
import javax.swing.BorderFactory;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX00PianoPanel extends javax.swing.JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX00PianoPanel.class);
    private static final PDFile _moduleInfo = PDFileManager.getManager().get(0);
   
    MXPianoComponent _keys;
    int _channel;

    public MX00PianoPanel(MXPianoComponent keys) {
        initComponents();
        _keys = keys;
        add(_keys);
    }
    
    public void autoAdjustHeight(int width) {
        this._keys.paintOnBuffer(null);
        int newHeight = _keys.getAdjustedHeight(width);
        Dimension d = new Dimension(width, newHeight);
        setPreferredSize(d);
    }
    
    public MXPianoComponent getKeys() {
        return _keys;
    }
    
    public void setChannel(int ch) {
        _channel = ch;
    }

    public int getChannel() {
        return _channel;
    }

    public void updateProgramNumber(int program) {
        String name = _moduleInfo.getModule().simpleGetName(program, -1, -1);
        setBorder(BorderFactory.createTitledBorder("TR "  + (_channel + 1) + " " + name + "(" + program + ")"));
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setBorder(javax.swing.BorderFactory.createTitledBorder("abc"));
        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
