/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX00DrumPadPanel extends javax.swing.JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX00DrumPadPanel.class);
    private static final PDFile _moduleInfo = PDFileManager.getManager().get(0);

    JToggleButton[] listDrums = new JToggleButton[256];
    ArrayList<ArrayList<JToggleButton>> layout;

    public MX00DrumPadPanel() {
        initComponents();
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
    }
    
    public void buttonLayout(JToggleButton btn) {
        if (layout == null) {
            layout = new ArrayList<ArrayList<JToggleButton>>();
            layout.add(null);
        }

        do {
            for (int y = 0; y < layout.size(); ++ y) {
                ArrayList<JToggleButton> row = layout.get(y);
                if (row == null) {
                    row = new ArrayList<JToggleButton>();
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    layout.set(y, row);
                }
                for (int x = 0; x < row.size(); ++ x ) {
                    JToggleButton cell = row.get(x);

                    if (cell == null) {
                        row.set(x, btn);
                        /*
                        GridBagConstraints c = new GridBagConstraints();
                        c.weightx = 1;
                        c.weighty = 1;
                        c.fill = GridBagConstraints.BOTH;
                        c.gridx = x;
                        c.gridy = y;
                        add(btn, c);
                        */
                        add(btn);

                        return;
                    }
                }
            }
            layout.add(null);
        }while(true);
    }
    
    protected void addNote(int note) {
        JToggleButton prev = listDrums[note];
        if (prev == null) {
            String drumNote = _moduleInfo.getDrumSet().simpleGetDrum(note);
            String noteName = MXUtilMidi.nameOfNote(note);
            if (drumNote != null) {
                noteName = drumNote;
            }
            JToggleButton button = new JToggleButton(noteName);
            button.setPreferredSize(new Dimension(150, 40));
            listDrums[note] = button;
            buttonLayout(listDrums[note]);
        }
    }
    
    long timer;
    
    public void setSelected(int note, boolean push) {
        JToggleButton btn = listDrums[note];
        if (btn == null) {
            return;
        }

        if (push) {
            btn.setSelected(true);
            timer = System.currentTimeMillis();
        }else {
            if (timer == 0) {
                btn.setSelected(false);
            }
            MXTimer.letsCountdown(100, new Runnable() {
                public void run() {
                    //if (timer + 100 >= System.currentTimeMillis()) {
                        btn.setSelected(false);
                    //}
                }
            });
        }
    }
    public void noteOn(int note) {
        setSelected(note, true);
    }
    
/*
    int colorIndex;
    Color[] colors = new Color[] {
        Color.white,
        Color.red,
        Color.yellow,
        Color.pink,
        Color.cyan
    };
    
  */
    public void noteOff(int note) {
        setSelected(note, false);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
