/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.swing;

import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.settings.MXSettingUtil;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXFileOpenChooser extends JFileChooser {

    static File currentDir = MXSettingUtil.getAppBaseDirectory().getAbsoluteFile();

    public static File getStartDirectory() {
        return currentDir;
    }
    
    public MXFileOpenChooser(File dir) {
        super(dir);
    }

    public MXFileOpenChooser() {
        this(currentDir);
    }

    public void approveSelection() {
        if (getDialogType() == JFileChooser.OPEN_DIALOG) {
            File[] selectedFilesList = this.getSelectedFiles();
            if (selectedFilesList.length == 0) {
                File selectedFile = this.getSelectedFile();
                if (selectedFile == null) {
                    JOptionPane.showMessageDialog(this, "Please select file.");
                    return;
                }
                selectedFilesList = new File[]{selectedFile};
            }
            ArrayList<File> notFound = new ArrayList();
            for (int i = 0; i < selectedFilesList.length; ++i) {
                if (selectedFilesList[i].exists() == false) {
                    notFound.add(selectedFilesList[i]);
                }
            }
            if (notFound.size() > 0) {
                JOptionPane.showMessageDialog(this, "File not found.\n" + notFound);
            }
            currentDir = getCurrentDirectory();
        }
        super.approveSelection();
    }

    public static File getExistFileRecursive(File file) {
        while (file != null && file.exists() == false) {
            file = file.getParentFile();
        }
        return file;
    }

    public static File getExistDirectoryRecursive(File file) {
        while (file != null && (file.exists() == false || file.isDirectory() == false)) {
            file = file.getParentFile();
        }
        return file;
    }

    public static void main(String[] args) {
        MXDebugLines.globalSwitchOn();
        JFileChooser chooser = new MXFileOpenChooser();
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        if (chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
            JOptionPane.showMessageDialog(null, "Selected file " + chooser.getSelectedFile().getPath());
        }
    }
    
    public void addExtension(String ext, String desc) {
        addChoosableFileFilter(new FileFilter() {
            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {                    
                    String lower = pathname.getName().toLowerCase();
                    if (lower.endsWith(ext)) {
                        return true;
                    }
                    return false;
                }
                return true;
            }
            @Override
            public String getDescription() {
                return desc;
            }
        });
    }
}
