/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class JTableWithFooter extends JTableWithColumnHeader {
    boolean _hideHeader = true;
    boolean _showFooter = true;

    JTableWithColumnHeader _footerTable;

    public JTableWithFooter(JPanel gridBagPanel) {
        super();
        
        java.awt.GridBagConstraints gridBagConstraints;
        
        if (gridBagPanel.getComponentCount() > 0) {
            new IllegalArgumentException("Need plaing JPanel for MJTable (but cleanup and continue)").printStackTrace();
            
            for(Component c : gridBagPanel.getComponents()) {
                gridBagPanel.remove(c);
            }
        }
        gridBagPanel.setLayout(new GridBagLayout());
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagPanel.add(this, gridBagConstraints);

        _footerTable = new JTableWithColumnHeader(getModel(), getColumnModel());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagPanel.add(_footerTable.getTableHeader(), gridBagConstraints);
        
        _footerTable.getTableHeader().setDefaultRenderer(new FoterRenderer(_footerTable.getTableHeader().getDefaultRenderer()));
        _footerTable.getTableHeader().setReorderingAllowed(false);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        
        gridBagPanel.add(new JPanel(), gridBagConstraints);  
    }
 
    public TableCellRenderer getCellRenderer(int row, int column){
        TableCellRenderer root = super.getCellRenderer(row, column);
        Component render = (Component)root;
        render.setEnabled(isEnabled());
        return (TableCellRenderer)render;
    }
    
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        _footerTable.setEnabled(e);
        _footerTable.getTableHeader().setEnabled(e);
    }

    public class FoterRenderer implements  TableCellRenderer{
        TableCellRenderer _base;
        
        public FoterRenderer(TableCellRenderer base) {
            _base = base;
        }
        
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)_base.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setText(String.valueOf(value));
            label.setEnabled(_footerTable.getTableHeader().isEnabled());
            return label;
        }
    }
}
