/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class JTableWithColumnHeader extends JTable {
    boolean _isColumn1AsHeader = true;
    
    public JTableWithColumnHeader() {
        super();
    }
    
    public JTableWithColumnHeader(TableModel model, TableColumnModel column) {
        super(model, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column){
        TableCellRenderer root = super.getCellRenderer(row, column);
        Component render = (Component)root.getTableCellRendererComponent(this, this.getModel().getValueAt(row, column), false, false, row, column);
        if (column == 0 && _isColumn1AsHeader) {
            TableCellRenderer headerRenderer = getTableHeader().getDefaultRenderer();
            JLabel newRender = (JLabel)headerRenderer;
            newRender.setText(String.valueOf(getValueAt(row, column)));
            render = newRender;
        }
        render.setEnabled(isEnabled());
        return (TableCellRenderer)render;
    }
}

