/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.settings;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.MXDebugLines;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class Path extends ArrayList<String> implements Cloneable {
    private static final MXDebugLines _debug = new MXDebugLines(Path.class);

    public Path() {
        super();
    }

    public Path clone() {
        Path p = new Path();
        p.addAll(this);
        return p;
    }
    
    public static Path parsePath(String name) throws MXSettingException {
        Path path = new Path();

        char[]buffer = name.toCharArray();
        StringBuffer writingChar = new StringBuffer();

        for (int x = 0; x < buffer.length; ++ x) {
            char ch = buffer[x];
            if (ch == '.') {
                String part = writingChar.toString();
                writingChar = new StringBuffer();
                if (part.length() >= 1) {
                    if (part.charAt(0) >= '0' && part.charAt(0) <= '9') {
                        try {
                            Integer.parseInt(part);
                        }catch(NumberFormatException e) {
                            throw new MXSettingException (e);
                        }
                    }
                    path.add(part);
                }
                continue;
            }
            if (ch == '[') {
                if (writingChar.length() >= 1) {
                    String part = writingChar.toString();
                    writingChar = new StringBuffer();
                    if (part.length() >= 1) {
                        if (part.charAt(0) >= '0' && part.charAt(0) <= '9') {
                            try {
                                Integer.parseInt(part);
                            }catch(NumberFormatException e) {
                                throw new MXSettingException (e);
                            }
                        }
                        path.add(part);
                    }
                }
                int nextClose = x + 1;
                while(nextClose < buffer.length) {
                    if (buffer[nextClose] == ']') {
                        break;
                    }
                    nextClose ++;
                }
                if (nextClose - x - 1 >= 0) {
                    String number = new String(buffer, x + 1, nextClose - x - 1);
                    if (number.length() == 0) {
                        number = "0";
                    }
                    try {
                        Integer.parseInt(number);
                        path.add(number);
                    }catch(NumberFormatException e) {
                        throw new MXSettingException (number);
                    }
                }else {
                    throw new MXSettingException ("???");
                }
                if (nextClose + 1 < buffer.length) {
                    if (buffer[nextClose + 1] == '.') {
                        nextClose ++;
                    }
                }
                x = nextClose;
                continue;
            }
            writingChar.append(ch);
        }
        if (writingChar.length() >= 1) {
            String part = writingChar.toString();
            writingChar = new StringBuffer();
            if (part.length() >= 1) {
                if (part.charAt(0) >= '0' && part.charAt(0) <= '9') {
                    try {
                        Integer.parseInt(part);
                    }catch(NumberFormatException e) {
                        _debug.printStackTrace(e, part + " is not number");
                        return null;
                    }
                }
                path.add(part);
            }
        }
        return path;
    }
 }
