/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

import java.util.Collection;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class PDProgram  implements DoubleIndexElement{
    int _programNumber = -1;
    String _programName = "?";
    DoubleIndex<PDBank> _bankMap = new DoubleIndex();

    public PDProgram(int number, String name) {
        _programNumber = number;
        _programName = name;
    }
    
    public int getProgramNumber() {
        return _programNumber;
    }

    public String getName() {
        return _programName;
    }

    public Collection<PDBank> listBanks() {
        return _bankMap.values();
    }
    
    public PDBank get(int msb, int lsb) {
        PDBank seek = new PDBank(this, msb, lsb, getName());
        return _bankMap.get(seek.getId());
    }

    public PDBank smartReserve(int msb, int lsb, String name) {
        PDBank x = get(msb, lsb);
        if (x == null) {
            x = new PDBank(this, msb, lsb, name);
            _bankMap.put(x);
        }
        return x;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        //str.append("[Folder " + p._mapSeq + ":" + p._mapName + "]");
        //str.append("[Program " + p._programNumber + ":" + p._programName + "]");
        //str.append("[Bank " + p._bankSeq + ":" + p._bankName + "]");
        return str.toString();
    }

    @Override
    public int getId() {
        return _programNumber;
    }
}
