/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

import java.util.Collection;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class PDMap implements DoubleIndexElement{
    int _seq;
    String _name;
    static int _seqReserve = 100;
    
    DoubleIndex<PDProgram> _programSet = new DoubleIndex();

    public PDMap(String name) {
        super();
        _name = name;
        _seq = _seqReserve ++;
    }
    
    public String getName() {
        return _name;
    }

    public Collection<PDProgram> listPrograms() {
        return _programSet.values();
    }

    public PDProgram get(int id) {
        return _programSet.get(id);
    }

    public PDProgram smartReserve(int id, String name) {
        PDProgram x = get(id);
        if (x == null) {
            x = new PDProgram(id, name);
            _programSet.put(x);
        }
        return x;
    }

    @Override
    public int getId() {
        return _seq;
    }
    
    public boolean isEmpty() {
        for (PDProgram x : _programSet.values()) {
            if (x._bankMap.size() >= 1) {
                return false;
            }
        }
        return true;
    }
}
