/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

import java.util.Collection;
import java.util.TreeMap;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class DoubleIndex<T extends DoubleIndexElement> {
    TreeMap<Integer, T> intIndex = new TreeMap();
    TreeMap<String, T> nameIndex = new TreeMap();
    
    public DoubleIndex() {
    }
    
    public T first() {
        if (intIndex.isEmpty()) {
            return null;
        }
        return intIndex.values().iterator().next();
    }

    public void put(T obj) {
        intIndex.put(obj.getId(), obj);
        nameIndex.put(obj.getName(), obj);
    }
    
    public T get(int id) {
        return intIndex.get(id);
    }

    public T get(String name) {
        return nameIndex.get(name);
    }
    
    public Collection<T> values() {
        return intIndex.values();
    }
    
    public int size() {
        return intIndex.size();
    }
}
