/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.programlist;

import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.domino.DTextFolder;
import jp.synthtarou.midimixer.libs.domino.DTextMessage;
import jp.synthtarou.midimixer.libs.domino.DTextMessageList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMidi;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDDrumSet;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDModule;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class GMFile implements PDFile {
    PDModule module = new GMLevel1();
    PDDrumSet drumSet = new GMLevel1Drum();
    PDModule drumModule = null;
    DTextMessageList ccList;

    @Override
    public String getName() {
        return "system Default";
    }

    @Override
    public PDModule getModule() {
        return module;
    }

    @Override
    public PDModule getDrumSet() {
        if (drumModule == null) {
            drumModule = new PDModule();
            PDBank bank = drumModule.smartReserve(getName()).smartReserve(0, "Standard Kit").smartReserve(-1, -1, "Standard Kit");
            bank.smartReserve(drumSet);
        }
        return drumModule;
    }

    @Override
    public DTextMessageList getCCList() {
        if (ccList == null) {
            ccList = new DTextMessageList();

            DTextFolder commandFolder = ccList.addFolder("Command", "Command");
            DTextFolder ccFolder = ccList.addFolder("Control Change", "Control Change");
            
            for (MXWrap<Integer> wrap : MXUtilMidi.createCommand()) {
                int command = wrap.value;
                if (command == MXMidi.COMMAND_CONTROLCHANGE) {
                    continue;
                }
                String name = MXUtilMidi.nameOfChannelMessage(command);
                MXMessage message = MXMessageFactory.fromShortMessage(0, new MXTraceNumber(), command, 0, 0);
                DTextMessage text = new DTextMessage(name, message.toDText(), message.getGate());
                commandFolder.addMessage(text);
            }
            for (int i = 0; i < 128; ++ i) {
                try {
                    MXMessage message = MXMessageFactory.fromShortMessage(0, new MXTraceNumber(), 0 + MXMidi.COMMAND_CONTROLCHANGE, i, 0);
                    DTextMessage text = new DTextMessage(MXUtilMidi.nameOfControlChange(i), message.toDText(), message.getGate());
                    ccFolder.addMessage(text);
                }catch(Exception e) {
                    e.printStackTrace();;
                }
            }
        }
        return ccList;
    }
}
