/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.ArrayList;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXVisitant16 {
    
    MXVisitant[] _array;

    public MXVisitant16() {
        _array = new MXVisitant[16];
        for(int i = 0; i < _array.length; ++ i) {
            _array[i] = new MXVisitant();
        }
    }

    public MXVisitant get(int channel) {
        return _array[channel];
    }
    
    public String toString() {
        ArrayList<MXVisitant> list = new ArrayList();
        for (MXVisitant v : _array) {
            list.add(v);
        }
        return list.toString();
    }
}
