/*
 * Copyright 2023 user0001.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

import jp.synthtarou.midimixer.windows.MXLIBWindows;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMIDIDriverUWP implements MXMIDIDriver {
    public static final MXMIDIDriverUWP _instance = new MXMIDIDriverUWP();
    
    MXLIBWindows windows10;

    public MXMIDIDriverUWP() {
        windows10 = new MXLIBWindows();
    }


    @Override
    public boolean isUsable() {
        return  windows10.isUsable();
    }

    @Override
    public void StartLibrary() {
        if (isUsable()) {
            windows10.StartLibrary();
        }
    }

    @Override
    public int InputDevicesRoomSize() {
        if (!isUsable()) {
            return 0;
        }
        return windows10.InputDevicesRoomSize();
    }

    @Override
    public String InputDeviceName(int device) {
        if (!isUsable()) {
            return "";
        }
        return windows10.InputDeviceName(device);
    }

    @Override
    public String InputDeviceId(int device) {
        if (!isUsable()) {
            return "";
        }
        return windows10.InputDeviceId(device);
    }

    @Override
    public boolean InputDeviceIsOpen(int device) {
        if (!isUsable()) {
            return false;
        }
        return windows10.InputDeviceIsOpen(device);
    }

    @Override
    public boolean InputDeviceOpen(int device) {
        if (!isUsable()) {
            return false;
        }
        windows10.InputDeviceQueryOpen(device);
        InputDeviceWaitDoneOpening(device, 2000);
        return InputDeviceIsOpen(device);
    }

    @Override
    public boolean InputDeviceQueryOpen(int device) {
        if (!isUsable()) {
            return false;
        }
        return windows10.InputDeviceQueryOpen(device);
    }

    @Override
    public boolean InputDeviceWaitDoneOpening(int device, long timeout) {
        if (!isUsable()) {
            return false;
        }
        return windows10.InputDeviceWaitDoneOpening(device, timeout);
    }

    @Override
    public boolean InputDeviceClose(int device) {
        if (!isUsable()) {
            return false;
        }
        return windows10.InputDeviceClose(device);
    }

    @Override
    public void InputSetReceiver(MXMIDIDriverReceiver receiver) {
        if (!isUsable()) {
            return;
        }
        MXLIBWindows.setReceiver(receiver);
    }

    @Override
    public int OutputDevicesRoomSize() {
        if (!isUsable()) {
            return 0;
        }
        return windows10.OutputDevicesRoomSize();
    }

    @Override
    public String OutputDeviceName(int device) {
        if (!isUsable()) {
            return "";
        }
        return windows10.OutputDeviceName(device);
    }

    @Override
    public String OutputDeviceId(int device) {
        if (!isUsable()) {
            return "";
        }
        return windows10.OutputDeviceId(device);
    }

    @Override
    public boolean OutputDeviceIsOpen(int device) {
        if (!isUsable()) {
            return false;
        }
        return windows10.OutputDeviceIsOpen(device);
    }

    @Override
    public boolean OutputDeviceOpen(int device) {
        if (!isUsable()) {
            return false;
        }
        return windows10.OutputDeviceOpen(device);
    }

    @Override
    public boolean OutputDeviceQueryOpen(int device) {
        if (!isUsable()) {
            return false;
        }
        return windows10.OutputDeviceQueryOpen(device);
    }

    @Override
    public boolean OutputDeviceWaitDoneOpening(int device, long timeout) {
        if (!isUsable()) {
            return false;
        }
        return windows10.OutputDeviceWaitDoneOpening(device, timeout);
    }

    @Override
    public boolean OutputDeviceClose(int device) {
        if (!isUsable()) {
            return false;
        }
        boolean x = windows10.OutputDeviceClose(device);
        return x;
    }

    @Override
    public boolean OutputShortMessage(int device, int message) {
        if (!isUsable()) {
            return false;
        }
        return windows10.OutputShortMessage(device, message);
    }

    @Override
    public boolean OutputLongMessage(int device, byte[] message) {
        if (!isUsable()) {
            return false;
        }
        return windows10.OutputLongMessage(device, message);
    }
}
