/*
 * Copyright 2023 yaman.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.midi;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXTraceNumber implements Comparable<MXTraceNumber>{
    public final long _clock;
    public final int _order;
    public final Throwable _traceBirthDay;
    
    long[] _thisWrap = new long[10];

    static long _lastClock = 0;
    static int _lastOrder = 0;
    
    static long[] _totalWrap = new long[10];
    static long[] _totalBottom = new long[10];
    static long[] _totalCount = new long[10];
    
    public String toString() {
        return _clock + ":" + _order;
    }
    
    public MXTraceNumber() {
        synchronized(MXTraceNumber.class) {
            long t = System.currentTimeMillis();
            if (t < _lastClock) {
                System.err.print(" --- something bad --- (never happens before)");
                t = _lastClock;
            }
            _clock = t;
            if (_clock != _lastClock) {
                _lastClock = _clock;
                _lastOrder = 0;
            }
            _order = _lastOrder;
            _lastOrder ++;
            _traceBirthDay = new Throwable("" + _clock + "(" + _order + ")");
        }
    }

    @Override
    public int compareTo(MXTraceNumber o) {
        if (o == null) {
            return -1;
        }
        if (_clock < o._clock) return -1;
        if (_clock > o._clock) return  1;
        if (_order < o._order) return -1;
        if (_order > o._order) return  1;
        return 0;
    }
    
    public long recordWrap(int selector) {
        long wrap = System.currentTimeMillis() - this._clock;
        _thisWrap[selector] = wrap;
        _totalWrap[selector] += wrap;
        _totalCount[selector] ++;
        if (_totalBottom[selector] < wrap) {
            _totalBottom[selector] = wrap;
        }
        return wrap;
    }
    
    public long thisWrap(int selector) {
        return _thisWrap[selector];
    }

    public static long totalWrap(int selector) {
        return _totalWrap[selector];
    }
    
    public static long totalCount(int selector) {
        return _totalCount[selector];
    }

    public static long totalBottom(int selector) {
        return _totalBottom[selector];
    }
}
