/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.logview;

import java.time.format.DateTimeFormatter;
import javax.swing.event.ListDataListener;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import jp.synthtarou.midimixer.libs.MultiThreadQueue;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXTimer;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class MXLogViewModel<T> /* implements javax.swing.ListModel */{
    /*
    private T[] listLogging = null;
    private int indexFrom = 0;
    private int indexTo = 0;
    private JList bind = null;
    private boolean _pause = false;
    private MXLogViewMidiRenderer _render;

    private ArrayList<ListDataListener> listListner = new ArrayList<>();
    private MultiThreadQueue<T> _queue;
    private String _name;

    public void setPause(boolean pause) {
        _pause = pause;
    }
    
    public synchronized void clearText() {
        indexFrom = 0;
        indexTo = 0;
    }
    
    public MXLogViewModel(String name, int maxRowCount) {
        listLogging = (T[])new Object[maxRowCount];
        _name = name;

        _queue = new MultiThreadQueue<T>();
        new Thread(new Runnable() {
            public  void run() {
                while(true) {
                    T text = _queue.pop();
                    if (text == null) {
                       _queue.quit();
                       break;
                    }
                    addTextInThread(text);
                }
            }
        }).start();
    }
    
    public MXLogViewMidiRenderer getRenderer() {
        if (bind == null) {
            throw new IllegalStateException("try installLiveViewModel before getRender");
        }
        return _render;
    }
    
    public void installLiveViewModel(JList list) {
        bind = list;
        bind.setModel(this);
        _render = new MXLogViewMidiRenderer(_name);
        list.setCellRenderer(_render);
    }

    @Override
    public int getSize() {
        int count = indexTo - indexFrom;
        return (count >= 0) ? count : (count + listLogging.length);
    }

    @Override
    public Object getElementAt(int index) {
        int pos = indexFrom + index;
        while (pos >= listLogging.length) {
            pos -= listLogging.length;
        }
        return listLogging[pos];
    }
    
    static byte[] _hex = "0123456789ABCDEF".getBytes();

    public void addLogLine(T msg)   {
        if (_pause) {
            return;
        }
        _queue.push(msg);
    }

    DateTimeFormatter simpleFormat = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    //DateTimeFormatter simpleFormat = DateTimeFormatter.ofPattern("HH:mm");

    private void addTextInThread(final T message) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    addTextInThread(message);
                }
            });
            return;
        }
        boolean eventRemoved = false;
        boolean eventAdded = false;
        
        listLogging[indexTo++] = message;
        if (indexTo >= listLogging.length) {
            indexTo -= listLogging.length;
        }
        eventAdded = true;

        if (indexTo == indexFrom) {
            listLogging[indexFrom++] = null;
            if (indexFrom >= listLogging.length) {
                indexFrom -= listLogging.length;
            }
            eventRemoved = true;
        }

        synchronized(this) {
            if (eventRemoved) {
                final ListDataEvent e = new ListDataEvent(this, ListDataEvent.INTERVAL_REMOVED, 0, 0);
                for (ListDataListener listener : listListner) {
                    listener.intervalRemoved(e);
                }
            }
            if (eventAdded) {
                int size = MXLogViewModel.this.getSize();
                ListDataEvent e = new ListDataEvent(this, ListDataEvent.INTERVAL_ADDED, size - 1, size - 1);
                for (ListDataListener listener : listListner) {
                    listener.intervalAdded(e);
                }
            }

            if (bind != null && eventRemoved == false) {
                bind.ensureIndexIsVisible(bind.getModel().getSize() -1);
            }
        }
    }

    @Override
    public synchronized void addListDataListener(ListDataListener l) {
        listListner.add(l);
    }

    @Override
    public synchronized void removeListDataListener(ListDataListener l) {
        listListner.remove(l);
    }

    boolean reserved = false;
    long lastTick = 0;

    public synchronized  void fireRepaint() {
        long tickNow = System.currentTimeMillis();
        if (tickNow - lastTick < 1000) {
            if (reserved) {
                return;
            }
            reserved = true;
            MXTimer.letsCountdown(1000 -tickNow - lastTick, new Runnable() {
                @Override
                public void run() {
                    fireImpl();
                }
            });
        }else {
            reserved = true;
            fireImpl();
        }
    }

    protected synchronized  void fireImpl() {
        if (reserved) {
            lastTick = System.currentTimeMillis();
            reserved = false;
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    final ListDataEvent e = new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, 0, getSize());
                    for (ListDataListener listener : listListner) {
                        listener.contentsChanged(e);
                    }
                }
            });
        }
    }*/
}
