/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs.domino;

import java.io.PrintStream;
import java.util.ArrayList;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class DTextMessageList {
    ArrayList<DTextFolder> _listFolder = new ArrayList();
    ArrayList<DTextMessage> _listMessage = new ArrayList();
    
    public DTextMessageList() {
        
    }
    
    public DTextFolder addFolder(String name, String id) {
        DTextFolder folder = new DTextFolder(name);
        folder._id = id;
        _listFolder.add(folder);
        return folder;
    }
    
    public DTextMessage addDCC(String name) {
        return null;
    }

    public void dump() {
        dump("", System.out);
    }

    public void dump(String indent, PrintStream out) {
        if (_listFolder.size() > 0) {
            out.println(indent + "*Folder = " + _listFolder.size());
            out.println(indent + "[");
            for (DTextFolder folder : _listFolder) {
                if (folder._id != null) {
                    out.println(indent + "+Folder:" + folder._name + "(" + folder._id + ")");
                }else {
                    out.println(indent + "+Folder:" + folder._name);
                }
                folder._list.dump(indent + "..", out);
            }
            out.println(indent + "]");
        }
        if (_listMessage.size() > 0) {
            out.println(indent + "*ControlChange = " + _listMessage.size());
            out.println(indent + "[");
            for (DTextMessage ccm : _listMessage) {
                out.println(indent + "-" + ccm._name + "[" + ccm._dataText + "]");
            }
            out.println(indent + "]");
        }
    }

    public void addFolder(DTextFolder folder) {
        _listFolder.add(folder);
    }
    
    public void addMessage(DTextMessage message) {
        _listMessage.add(message);
    }
}
