/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXWrapList<T> extends ArrayList<MXWrap<T>> implements ListModel, ComboBoxModel {
    private static final MXDebugLines _debug = new MXDebugLines(MXWrapList.class);

    boolean _ignoreCase = false;

    public MXWrapList() {
        super();
    }

    public boolean ignoreCase() {
        return _ignoreCase;
    }
    
    public void setIgnoreCase(boolean ignore) {
        _ignoreCase = ignore;
    }

    public List<String> nameList() {
        ArrayList<String> list = new ArrayList();
        for (MXWrap<T> e : this) {
            list.add(e.name);
        }
        return list;
    }

    public List<T> valueList() {
        ArrayList<T> list = new ArrayList();
        for (MXWrap<T> e : this) {
            list.add(e.value);
        }
        return list;
    }
   
    public String nameOfIndex(int x) {
        return get(x).name;
    }

    public boolean existsName(String name) {
        if (_ignoreCase) {
            for (MXWrap<T> e : this) {
                if(e.name.equalsIgnoreCase(name)) {
                    return true;
                }
            }
            return false;
        }else {
            for (MXWrap<T> e : this) {
                if(e.name.equals(name)) {
                    return true;
                }
            }
            return false;
        }
    }

    public int indexOfName(String name) {
        if (_ignoreCase) {
            int x = 0;
            for (MXWrap<T> e : this) {
                if(e.name.equalsIgnoreCase(name)) {
                    return x;
                }
                x ++;
            }
            return -1;
        }else {
            int x = 0;
            for (MXWrap<T> e : this) {
                if(e.name.equals(name)) {
                    return x;
                }
                x ++;
            }
            return -1;
        }
    }
    
    public T valueOfIndex(int x) {
        return get(x).value;
    }
    
    public T valueOfName(String name) {
        int x = indexOfName(name);
        if (x < 0) {
            return null;
        }
        return get(x).value;
    }

    public int indexOfValue(T value) {
        int x = 0;
        for (MXWrap<T> e : this) {
            if(e.value == value) {
                return x;
            }
            x ++;
        }
        x = 0;
        for (MXWrap<T> e : this) {
            if(e.value != null && value != null) {
                if (e.value.equals(value)) {
                    return x;
                }
            }
            x ++;
        }
        return -1;
    }

    public boolean addNameAndValue(String name, T value) {
        return add(new MXWrap(name, value));
    }
    
    @Override
    public boolean add(MXWrap<T> value) {
        boolean x = super.add(value);
        return x;
    }

    @Override
    public int getSize() {
        return size();
    }

    @Override
    public Object getElementAt(int index) {
        return get(index);
    }

    List<ListDataListener> _listeners = new ArrayList(); //Sorry Under Constructin / View Recload -> Your Self
    Object _selected = null;
    
    @Override
    public void addListDataListener(ListDataListener l) {
        _listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        _listeners.remove(l);
    }

    @Override
    public void setSelectedItem(Object o) {
        _selected = o;
    }

    @Override
    public Object getSelectedItem() {
        if (_selected == null) {
            //　自動で初期化する
            if (size() > 0) {
                _selected = get(0);
            }
        }
        return _selected;
    }
    
    public T readCombobox(JComboBox box) {
        ComboBoxModel model = box.getModel();
        MXWrap<T> item = (MXWrap)model.getSelectedItem();
        if (item != null) {
            return item.value;
        }
        return null;
    }

    public void writeComboBox(JComboBox box, T value) {
        ComboBoxModel model = this;
        box.setModel(this);
        for (int i = 0; i < model.getSize(); ++ i) {
            MXWrap<T> item = (MXWrap)model.getElementAt(i);
            if (item != null) {
                if (value.getClass().isPrimitive()) {
                    if (item.value == value) {
                        box.setSelectedIndex(i);
                        return;
                    }
                }else {
                    if (item.value == null && value == null) {
                        box.setSelectedIndex(i);
                        return;
                    }
                    if (item.value != null && value != null) {
                        if (item.value.equals(value)) {
                            box.setSelectedIndex(i);
                            return;
                        }
                    }
                }
            }
        }
    }
}
