/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer.libs;


import java.io.PrintStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXDebugLines {
    private static final MXDebugLines _debug = new MXDebugLines(MXDebugLines.class);
    private PrintStream _output = System.out;
    
    public static void dumpEnv() {
        if (_debug.isDebug()) {
            Properties props = System.getProperties();
            Enumeration keys = props.keys();
            _debug.println("System.getProperties = ");
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                _debug.println("    " + key + " = " + value);
            }

            Map<String, String> envs = System.getenv();
            _debug.println("System.getenv = ");
            for (String key : envs.keySet()) {
                String value = (String)envs.get(key);
                _debug.println("    " + key + " = " + value);
            }
        }

    }
    
    public static void main(String[] args) {
        _debug.switchOn();
        _debug.printStackTrace();

        dumpEnv();
        
        test();
    }
    
    public static void test() {
        _debug.printStackTrace(new Throwable());
    }
    
    protected String _name;
    
    public MXDebugLines(Class cls) {
        _name = cls.getName();
        if (_name != null) {
            int x = _name.lastIndexOf('.');
            if (x >= 0) {
                _name = _name.substring(x+1);
            }
            if (_target == null) {
                //when 1st initialize, i happens
                return;
            }
            if (_target.contains(_name)) {
                _switch = true;
            }
        }
    }
    
    public boolean isDebug() {
        return (_globalSwitch || _switch);
    }
    
    public void println(String text) {
        if (isDebug()) {
            _output.println(_name + ": " + text);
        }
    }

    public void print(String text) {
        if (isDebug()) {
            _output.print(_name + ": " + text);
        }
    }

    public void println() {
        if (isDebug()) {
            _output.println(_name + ": ");
        }
    }

    public void printStackTrace() {
        if (isDebug()) {
            Throwable th= new Throwable();
            StackTraceElement[] elems = th.getStackTrace();
            _output.println("print stack trace = ");
            for (int i = 1 ; i < elems.length; ++ i) {
                StackTraceElement x = elems[i];
                _output.println("    "  + x);
            }
        }
    }

    public void printStackTrace(Throwable th) {
        if (isDebug()) {
            StackTraceElement[] elems = th.getStackTrace();
            _output.println("print stack trace = " + th.getClass() + ":" + th.getMessage());
            for (int i = 0 ; i < elems.length; ++ i) {
                StackTraceElement x = elems[i];
                _output.println("    "  + x);
            }
        }
    }

    public void printStackTrace(Throwable th, String text) {
        if (isDebug()) {
            println(text);
            printStackTrace(th);
        }
    }

    private boolean _switch = false;
    private static boolean _globalSwitch = false;
    private static HashSet<String> _target = new HashSet();

    public static void initDebugLine(String[] args) {
        String debug1 = System.getenv("DEBUG");
        String debug2 = System.getProperty("DEBUG");
        
        Comparator<String> ignoreCase = new Comparator<String>() {
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        };
        TreeSet<String> test = new TreeSet(ignoreCase);
        test.add("true");
        test.add("yes");
        test.add("on");
        test.add("1");
        if (debug1 != null && test.contains(debug1)) {
            _globalSwitch = true;
        } else if (debug2 != null && test.contains(debug2)) {
            _globalSwitch = true;
        } else {
            if (debug1 != null) {
                _target.add(debug1);
            }
            if (debug2 != null) {
                _target.add(debug2);
            }
        }
        for (int i = 0; i < args.length; ++ i) {
            if (args[i].equalsIgnoreCase("--debug")) {
                _globalSwitch = true;
            }
        }
    }
   
    public static void parseArgs(String[] args) {
        for (String text : args) {
            if (text.startsWith("--debug=")) {
                _target.add(text.substring(8));
            }else if (text.equals("--degbug")) {
                _globalSwitch = true;
            }
        }
    }
    
    public static void globalSwitchOn() {
        _globalSwitch = true;
    }

    public static void globalSwitchOff() {
        _globalSwitch = false;
    }

    public void switchOn() {
        _switch = true;
    }

    public void switchOff() {
        _switch = false;
    }
}
