/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer;

import java.awt.Color;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.swing.themes.ThemeManager;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class MXStatic {

    public static Color sliderColor(int column) {
        column /= 4;
        boolean sprite = (column % 2 == 0) ? true : false;
        if (sprite) {
            if (ThemeManager.getInstance().colorfulMetalTheme) {
                return MetalLookAndFeel.getCurrentTheme().getControlShadow();
            }
            return colorSlider1;
        }else {
            if (ThemeManager.getInstance().colorfulMetalTheme) {
                return MetalLookAndFeel.getCurrentTheme().getControlHighlight();
            }
            return colorSlider2;
        }
    }
    public static final String LOOPMIDI_NAME = "EX MIDIMixer Out";
    public static final String MX_APPNAME = "MIX Recipe";
    public static final String MX_APPNAME_WITH_VERSION = "MIX Recipe 0.25";
    public static final String MX_EDITING = "*** EDIT CONTROl MODE ***";
    public static final int DRUM_CH = 9;
    
    static final MXStatic _setting = new MXStatic();
    public static final int TOTAL_PORT_COUNT = 16;

    public static final int SLIDER_COLUMN_COUNT = 17;
    public static final int SLIDER_ROW_COUNT = 1;
    public static final int CIRCLE_ROW_COUNT = 4;
    public static final int DRUM_ROW_COUNT = 3;

    public static boolean _trapMouseForOnlySelect = false;

    private static final Color colorSlider1 = MXUtil.mixedColor(MXUtil.mixedColor(Color.blue, Color.lightGray, 50), Color.white, 50);
    private static final Color colorSlider2 = MXUtil.mixedColor(colorSlider1, Color.white, 50);
    
    public static final int MOUSE_VELOCITY = 100;
}
