/*
 * Copyright 2023 Syntarou YOSHIDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.synthtarou.midimixer;

import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.swing.themes.ThemeManagerDialog;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMainWindow extends javax.swing.JFrame {
    private static final MXDebugLines _debug = new MXDebugLines(MXMainWindow.class);

    MXMain _main;

    /**
     * Constructor
     */
    public MXMainWindow(MXMain main) {
        _main = main;
        initComponents();
        jMenuBar1.add(Box.createHorizontalGlue());
        JMenu helpParent = new JMenu("Help");
        jMenuBar1.add(helpParent);
        
        JMenuItem  helpMenu = new JMenuItem("Wiki");
        helpMenu.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                String wikiPage = "https://osdn.net/projects/midimixer/wiki/FrontPage";
                try{
                    Desktop.getDesktop().browse(new URI(wikiPage));
                }catch(Exception e){
                    JOptionPane.showMessageDialog(MXMainWindow.this, "Failed launch www-Browser", "Error", JOptionPane.ERROR_MESSAGE);
                }    
            }
        });
        helpParent.add(helpMenu);
        JMenuItem  helpMenu2 = new JMenuItem("Forum");
        helpMenu2.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                String wikiPage = "https://osdn.net/projects/midimixer/forums/";
                try{
                    Desktop.getDesktop().browse(new URI(wikiPage));
                }catch(Exception e){
                    JOptionPane.showMessageDialog(MXMainWindow.this, "Failed launch www-Browser", "Error", JOptionPane.ERROR_MESSAGE);
                }    
            }
        });
        helpParent.add(helpMenu2);
        JMenu appMenu = new JMenu(MXStatic.MX_APPNAME_WITH_VERSION);
        jMenuBar1.add(appMenu);

        JMenuItem themeMenu = new JMenuItem("Theme");
        appMenu.add(themeMenu);
        themeMenu.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                new ThemeManagerDialog(MXMainWindow.this, true).setVisible(true);
            }
        });

        JMenuItem versionMenu = new JMenuItem("About MIXRecipe");
        appMenu.add(versionMenu);
        versionMenu.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                MXVersionDialog.showAsModal(MXMainWindow.this);
            }
        });
    }

    /**
     * ウィンドウの初期化
     */
    public void initLatebind(Collection<MXReceiver> viewList) {
        setTitle(MXStatic.MX_APPNAME_WITH_VERSION);
        setSize(new Dimension(1200, 700));

        MXUtil.centerWindow(this);
        setVisible(true);
        
        int count = 0;
        for (MXReceiver re : viewList) {
            jTabbedPane1.add(re.getReceiverName(), re.getReceiverView());
            JMenuItem menu = new JMenuItem(re.getReceiverName());
            menu.addActionListener(new WindowMenuItemListener(count));
            count ++;
            jMenuWindow.add(menu);
        }
        {
            JMenuItem menu = new JMenuItem("Master Key");
            menu.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    MXMain.getMain().getMasterKeys().createWindow();
                }
            });
            jMenuWindow.add(menu);
        }
        {
            JMenuItem menu = new JMenuItem("Free Console / SysEX");
            menu.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    MXMain.getMain().openFreeConsole();
                }
            });
            jMenuWindow.add(menu);
        }
        jTabbedPane1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                tabPanelStateChanged(evt);
            }
        });
    }
    
    class WindowMenuItemListener implements ActionListener {
        int _page;
        
        public WindowMenuItemListener(int page) {
            _page = page;
        }
        
        @Override
        public void actionPerformed(ActionEvent e) {
            jTabbedPane1.setSelectedIndex(_page);
        }
        
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuSaveNow = new javax.swing.JMenuItem();
        jMenuWindow = new javax.swing.JMenu();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.LINE_AXIS));
        getContentPane().add(jTabbedPane1);

        jMenuFile.setText("File");

        jMenuSaveNow.setText("Save All Parameters");
        jMenuSaveNow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveNowActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuSaveNow);

        jMenuBar1.add(jMenuFile);

        jMenuWindow.setText("Window");
        jMenuBar1.add(jMenuWindow);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuSaveNowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveNowActionPerformed
        _main.saveEverySettingToFile();
    }//GEN-LAST:event_jMenuSaveNowActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuSaveNow;
    private javax.swing.JMenu jMenuWindow;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

    /**
     * MainFrame内のTABを管理
     * @return MainFrame内のTAB
     */
    public JTabbedPane getTabbedPanel() {
        return jTabbedPane1;
    }

    private void tabPanelStateChanged(javax.swing.event.ChangeEvent evt) {                                          
        int x = jTabbedPane1.getSelectedIndex();
        if (x >= 0) {
            Component  view = jTabbedPane1.getComponentAt(x);
            view.requestFocusInWindow();
        }            
    }
}
