/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.windows;

import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.driver.MXMIDIDriverReceiver;

public class MXLIBWindows {
    private boolean loaded = false;
    public static MXMIDIDriverReceiver _receiver = null;
    static MXLIBWindows main = new MXLIBWindows();
    int microSynth = -1;

    public MXLIBWindows() {
        try {
            System.loadLibrary("MXLIB01");
            this.StartLibrary();
            this.loaded = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isUsable() {
        return this.loaded;
    }

    public static void setReceiver(MXMIDIDriverReceiver receiver) {
        _receiver = receiver;
    }

    public native void StartLibrary();

    public native int InputDevicesRoomSize();

    public native String InputDeviceName(int var1);

    public native String InputDeviceId(int var1);

    public native boolean InputDeviceIsOpen(int var1);

    public native boolean InputDeviceOpen(int var1);

    public native boolean InputDeviceQueryOpen(int var1);

    public native boolean InputDeviceWaitDoneOpening(int var1, long var2);

    public native boolean InputDeviceClose(int var1);

    public native int OutputDevicesRoomSize();

    public native String OutputDeviceName(int var1);

    public native String OutputDeviceId(int var1);

    public native boolean OutputDeviceIsOpen(int var1);

    public native boolean OutputDeviceOpen(int var1);

    public native boolean OutputDeviceQueryOpen(int var1);

    public native boolean OutputDeviceWaitDoneOpening(int var1, long var2);

    public native boolean OutputDeviceClose(int var1);

    public native boolean OutputShortMessage(int var1, int var2);

    public native boolean OutputLongMessage(int var1, byte[] var2);

    private static void cbCallText(String text) {
        System.out.println("Text [" + text.toString() + "]");
    }

    private static void cbCallShortMessage(int port, int message) {
        if (_receiver != null) {
            _receiver.DoShortMessage(port, new MXTraceNumber(), message);
        }
    }

    private static void cbCallLongMessage(int port, byte[] data) {
        if (_receiver != null) {
            _receiver.DoLongMessage(port, new MXTraceNumber(), data);
        }
    }

    public void main2(String[] args) {
        try {
            long spent;
            int size = this.InputDevicesRoomSize();
            System.out.println("inputSize = " + size);
            for (int i = 0; i < size; ++i) {
                String name = this.InputDeviceName(i);
                String id = this.InputDeviceId(i);
                System.out.println("inputName[" + i + "]=" + name);
                System.out.println("inputID[" + i + "]=" + id);
                this.InputDeviceQueryOpen(i);
                this.InputDeviceWaitDoneOpening(i, 1000L);
                System.out.println("ReserveDone " + name);
            }
            int outsize = this.OutputDevicesRoomSize();
            System.out.println("outputSize = " + outsize);
            for (int i = 0; i < outsize; ++i) {
                System.out.println("List " + i + "/" + outsize);
                String name = this.OutputDeviceName(i);
                String id = this.OutputDeviceId(i);
                System.out.println("outputName[" + i + "]=" + name);
                System.out.println("outputID[" + i + "]=" + id);
                if (!name.startsWith("Microsoft")) continue;
                this.OutputDeviceQueryOpen(i);
                this.OutputDeviceWaitDoneOpening(i, 1000L);
                System.out.println("ReserveDone " + name);
            }
            long start = System.currentTimeMillis();
            while ((spent = System.currentTimeMillis() - start) < 20000L) {
                int count = 0;
                for (int i = 0; i < outsize; ++i) {
                    String name = this.OutputDeviceName(i);
                    if (name.startsWith("Microsoft")) {
                        System.out.println("Found Microsoft " + name);
                        this.OutputDeviceOpen(i);
                        this.microSynth = i;
                        System.out.println("microSynth = " + this.microSynth);
                    }
                    if (!this.OutputDeviceWaitDoneOpening(i, 1000L)) continue;
                    ++count;
                }
                if (count == 0) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("-7");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(300000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        main.main2(args);
    }
}

