/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;
import jp.synthtarou.midimixer.mx70console.ConsoleModel;
import jp.synthtarou.midimixer.mx70console.MX70Panel;

public class MX70Process
implements MXSettingTarget {
    MXSetting _setting;
    MX70Panel _view;
    ConsoleModel _outsideInput = new ConsoleModel();
    ConsoleModel _insideInput = new ConsoleModel();
    ConsoleModel _insideOutput = new ConsoleModel();
    ConsoleModel _outsideOutput = new ConsoleModel();

    public MX70Process() {
        this._setting = new MXSetting("FreeConsole");
        this._setting.setTarget(this);
    }

    public void readSettings() {
        this._setting.readFile();
    }

    public void createWindow() {
        if (this._view != null && this._view.isOwnerWindowVisible()) {
            return;
        }
        this._view = new MX70Panel(this);
        this._view.showAsWindow();
    }

    public void addOutsideInput(ConsoleElement e) {
        this._outsideInput.add(e);
        e.getTraceNumber().recordWrap(0);
    }

    public void addInsideInput(MXMessage msg) {
        ConsoleElement e = new ConsoleElement(msg._traceNumber, msg);
        this._insideInput.add(e);
        e.getTraceNumber().recordWrap(1);
    }

    public void addInsideOutput(MXMessage msg) {
        ConsoleElement e = new ConsoleElement(msg._traceNumber, msg);
        this._insideOutput.add(e);
        e.getTraceNumber().recordWrap(2);
    }

    public void addOutsideOutput(ConsoleElement e) {
        this._outsideOutput.add(e);
        e.getTraceNumber().recordWrap(3);
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
    }
}

