/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.mx70console.ConsoleElement;

public class ConsoleModel
implements ListModel<String> {
    ArrayList<ConsoleElement> _list = new ArrayList();
    ArrayList<ListDataListener> _listener = new ArrayList();
    static final int _capacity = 5000;
    static final int _timer = 500;
    int _startPos = 0;
    int _writePos = 0;
    JList _refList;
    MXTraceNumber _selectedTraceNumber = null;
    ListCellRenderer<Object> _renderer = new ListCellRenderer<Object>(){
        DefaultListCellRenderer _def = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList list, Object var, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this._def.getListCellRendererComponent((JList<?>)list, var, index, isSelected, cellHasFocus);
            ConsoleElement value = ConsoleModel.this.getConsoleElement(index);
            if (value == null) {
                return c;
            }
            if (ConsoleModel.this._selectedTraceNumber == value.getTraceNumber()) {
                c.setForeground(Color.red);
                if (ConsoleModel.this._selectedTraceNumber != null) {
                    c.setBackground(Color.cyan);
                } else {
                    c.setBackground(Color.gray);
                }
            }
            return c;
        }
    };
    boolean reserved = false;
    long lastTick = 0L;
    boolean reserved2 = false;
    long lastTick2 = 0L;

    public void bind(JList list) {
        list.setModel(this);
        list.setCellRenderer(this._renderer);
        this._refList = list;
    }

    @Override
    public int getSize() {
        return 5000;
    }

    @Override
    public String getElementAt(int index) {
        ConsoleElement e = this.getConsoleElement(index);
        if (e == null) {
            return "";
        }
        return e.formatMessageLong();
    }

    public int viewIndex(int viewpos) {
        int index = viewpos + this._list.size() - 5000 + this._startPos;
        if (index < 0) {
            return -1;
        }
        while (index >= 5000) {
            index -= 5000;
        }
        if (index >= this._list.size()) {
            return -1;
        }
        return index;
    }

    public int indexView(int index) {
        int viewpos;
        for (viewpos = index - this._list.size() + 5000 - this._startPos; viewpos < 0; viewpos += 5000) {
        }
        while (viewpos >= 5000) {
            viewpos -= 5000;
        }
        return viewpos;
    }

    public ConsoleElement getConsoleElement(int viewpos) {
        int index = this.viewIndex(viewpos);
        if (index >= 0) {
            return this._list.get(index);
        }
        return null;
    }

    public synchronized void add(ConsoleElement e) {
        if (this._writePos >= 5000) {
            this._writePos = 0;
        }
        if (this._list.size() >= 5000) {
            MXTraceNumber prevNumber;
            int comp;
            ConsoleElement prevE;
            int prev = this._writePos - 1;
            if (prev < 0) {
                prev = 4999;
            }
            if ((prevE = this._list.get(prev)) != null && (comp = (prevNumber = prevE.getTraceNumber()).compareTo(e.getTraceNumber())) > 0) {
                System.err.println("************************************");
                System.err.println("This");
                e.getTraceNumber()._traceBirthDay.printStackTrace();
                System.err.println("Before");
                prevE.getTraceNumber()._traceBirthDay.printStackTrace();
            }
            this._list.set(this._writePos, e);
            ++this._writePos;
            this._startPos = this._writePos;
        } else {
            this._list.add(e);
            ++this._writePos;
        }
        this.fireRepaint();
    }

    public void fireRepaint() {
        long tickNow = System.currentTimeMillis();
        if (tickNow - this.lastTick < 500L) {
            if (this.reserved) {
                return;
            }
            this.reserved = true;
            MXTimer.letsCountdown(500L - (tickNow - this.lastTick), new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireImpl();
                }
            });
        } else {
            this.reserved = true;
            this.fireImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireImpl() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireImpl();
                }
            });
            return;
        }
        if (this.reserved) {
            this.lastTick = System.currentTimeMillis();
            this.reserved = false;
            ConsoleModel consoleModel = this;
            synchronized (consoleModel) {
                ListDataEvent e = new ListDataEvent(this, 0, 0, this._list.size());
                try {
                    for (ListDataListener listener : this._listener) {
                        listener.contentsChanged(e);
                    }
                    this._refList.ensureIndexIsVisible(4999);
                    this._refList.repaint();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this._listener.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this._listener.remove(l);
    }

    public void setSelectedTraceNumber(final MXTraceNumber selection) {
        this._selectedTraceNumber = selection;
        long tickNow = System.currentTimeMillis();
        if (tickNow - this.lastTick2 < 100L) {
            if (this.reserved2) {
                return;
            }
            this.reserved2 = true;
            MXTimer.letsCountdown(100L - (tickNow - this.lastTick2), new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireSelectTraceNumber(selection);
                }
            });
        } else {
            this.reserved2 = true;
            this.fireSelectTraceNumber(selection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectTraceNumber(MXTraceNumber selection) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireImpl();
                }
            });
            return;
        }
        if (selection == null) {
            this._refList.repaint();
            return;
        }
        if (this.reserved2) {
            this.lastTick2 = System.currentTimeMillis();
            this.reserved2 = false;
            ConsoleModel consoleModel = this;
            synchronized (consoleModel) {
                MXTraceNumber t1;
                ConsoleElement e2;
                int low = 0;
                int high = this.getSize();
                while (low < high) {
                    int middle = (high + low) / 2;
                    ConsoleElement elem = this.getConsoleElement(middle);
                    if (elem == null) {
                        low = middle + 1;
                        continue;
                    }
                    MXTraceNumber middlesNumber = elem.getTraceNumber();
                    if (middlesNumber == null) {
                        low = middle + 1;
                        continue;
                    }
                    int comp = middlesNumber.compareTo(selection);
                    if (comp == 0) {
                        low = high = middle;
                        break;
                    }
                    if (comp < 0) {
                        low = middle + 1;
                        continue;
                    }
                    high = middle - 1;
                }
                if (low != high) {
                    this._refList.ensureIndexIsVisible(low);
                    this._refList.repaint();
                    return;
                }
                while (low >= 0) {
                    ConsoleElement e1 = this.getConsoleElement(low);
                    e2 = this.getConsoleElement(low - 1);
                    if (e1 == null || e2 == null) break;
                    t1 = e1.getTraceNumber();
                    MXTraceNumber t2 = e2.getTraceNumber();
                    if (t1 == null || t2 == null || t1.compareTo(t2) != 0) break;
                    --low;
                }
                while (high + 1 < this.getSize()) {
                    ConsoleElement e1 = this.getConsoleElement(high);
                    e2 = this.getConsoleElement(high + 1);
                    if (e1 == null || e2 == null) break;
                    t1 = e1.getTraceNumber();
                    MXTraceNumber t2 = e2.getTraceNumber();
                    if (t1 == null || t2 == null || t1.compareTo(t2) != 0) break;
                    ++high;
                }
                this._refList.ensureIndexIsVisible(low);
                this._refList.repaint();
            }
        }
    }
}

