/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;

public class ConsoleElement
implements Comparable<ConsoleElement> {
    public static final int TYPE_DWORD = 1;
    public static final int TYPE_DATA = 2;
    public static final int TYPE_MESSAGE = 3;
    private MXTraceNumber _traceNumber;
    private int _port;
    private int _type;
    private int _dword;
    private byte[] _data;
    private MXMessage _message;

    public ConsoleElement(MXTraceNumber traceNumber, int port, int dword) {
        this._type = 1;
        this._port = port;
        this._dword = dword;
        this._traceNumber = traceNumber;
    }

    public ConsoleElement(MXTraceNumber traceNumber, int port, byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        this._type = 2;
        this._port = port;
        this._data = data;
        this._traceNumber = traceNumber;
    }

    public ConsoleElement(MXTraceNumber traceNumber, MXMessage message) {
        this._type = 3;
        this._message = message;
        this._port = message.getPort();
        this._traceNumber = traceNumber;
    }

    public int getType() {
        return this._type;
    }

    public MXTraceNumber getTraceNumber() {
        return this._traceNumber;
    }

    public int getDword() {
        if (this._type != 1) {
            throw new IllegalStateException("getDowrd <> not DWORD type");
        }
        return this._dword;
    }

    public byte[] getData() {
        if (this._type != 2) {
            throw new IllegalStateException("getDowrd <> not DWORD type");
        }
        return this._data;
    }

    public MXMessage getMessage() {
        if (this._type != 3) {
            throw new IllegalStateException("getDowrd <> not DWORD type");
        }
        return this._message;
    }

    public String formatMessageDump() {
        switch (this._type) {
            case 1: {
                int status = this._dword >> 16 & 0xFF;
                int data1 = this._dword >> 8 & 0xFF;
                int data2 = this._dword & 0xFF;
                return MXUtil.toHexFF(status) + "- " + MXUtil.toHexFF(data1) + " " + MXUtil.toHexFF(data2);
            }
            case 2: {
                return MXUtil.dumpHexFF(this._data);
            }
            case 3: {
                String exString = "";
                if (this._message.isBinMessage()) {
                    byte[] data = this._message.getDataBytes();
                    return MXUtil.dumpHexFF(data);
                }
                int status = this._message.getStatus();
                int data1 = this._message.getData1();
                int data2 = this._message.getData2();
                return MXUtil.toHexFF(status) + " " + MXUtil.toHexFF(data1) + " " + MXUtil.toHexFF(data2);
            }
        }
        return "Type=" + this._type;
    }

    public String formatMessageLong() {
        String port = Character.toString((char)(65 + this._port)) + ")";
        String timing = "";
        String dump = this.formatMessageDump();
        switch (this._type) {
            case 1: {
                return port + dump + ConsoleElement.toSegmentText(this._dword) + timing;
            }
            case 2: {
                return port + dump + "[Binary]" + timing;
            }
            case 3: {
                String exString = "";
                if (!this._message.isBinMessage() || this._message.isDataentry()) {
                    int col = this._message.getDwordCount();
                    StringBuffer ret = new StringBuffer();
                    for (int i = 0; i < col; ++i) {
                        int dword = this._message.getAsDword(i);
                        String str = ConsoleElement.toSegmentText(dword);
                        ret.append(str);
                        if (i + 1 >= col) continue;
                        ret.append("|");
                    }
                    if (col == 1) {
                        return port + dump + ret + timing;
                    }
                    return port + dump + "[" + ret + " ]" + timing;
                }
                return port + dump + "[Binary]" + timing;
            }
        }
        return port + dump + "[???]" + timing;
    }

    public static String toSegmentText(byte[] data) {
        return "[" + MXUtil.dumpHexFF(data) + "]]";
    }

    public static String toSegmentText(int dword) {
        String channel;
        int command;
        int status = dword >> 16 & 0xFF;
        int data1 = dword >> 8 & 0xFF;
        int data2 = dword & 0xFF;
        if (status >= 128 && status <= 240) {
            command = status & 0xF0;
            channel = Integer.toString(status & 0xF);
        } else {
            command = status;
            channel = "";
        }
        if (command == 144) {
            return "[On " + channel + ":" + MXUtilMidi.nameOfNote(data1) + "=" + data2 + "]";
        }
        if (command == 128) {
            return "[Off " + channel + ":" + MXUtilMidi.nameOfNote(data1) + "=" + data2 + "]";
        }
        if (command == 160) {
            return "[PolyPress " + channel + ":" + MXUtilMidi.nameOfNote(data1) + "=" + data2 + "]";
        }
        if (command == 192) {
            return "[Program " + channel + ":" + data1 + "]";
        }
        if (command == 208) {
            return "[ChannelPress " + channel + ":" + data1 + "]";
        }
        if (command == 224) {
            return "[Pitch " + channel + ":" + MXUtil.toHexFF(data1) + MXUtil.toHexFF(data2) + "=" + (data2 << 7 + data1) + "]";
        }
        if (command == 242) {
            return "[SongPos " + data1 + "]";
        }
        if (command == 243) {
            return "[SongSel " + data1 + "]";
        }
        if (command == 176) {
            String ccname = MXUtilMidi.nameOfControlChange(data1);
            return "[CC-" + ccname + " " + channel + ":" + MXUtil.toHexFF(data2) + "]";
        }
        return "****" + MXUtil.toHexFF(status) + MXUtil.toHexFF(data1) + MXUtil.toHexFF(data2);
    }

    @Override
    public int compareTo(ConsoleElement arg0) {
        MXTraceNumber e1 = this._traceNumber;
        MXTraceNumber e2 = arg0._traceNumber;
        if (e1 == null && e2 == null) {
            return 0;
        }
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        return e1.compareTo(e2);
    }
}

