/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx60output;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.mx60output.MX60Data;
import jp.synthtarou.midimixer.mx60output.MX60MidiOutListPanel;
import jp.synthtarou.midimixer.mx60output.MX60Process;

public class MX60View
extends JPanel {
    MX60Process _process;
    private static final MXDebugLines _debug = new MXDebugLines(MX60View.class);
    JTableWithColumnHeader _jTableSkip;
    boolean _useSkipCC = true;
    MXWrapList<Integer> _recPortList;
    private JCheckBox jCheckBoxUseSkip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelOutputSelect;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;

    public MX60View(MX60Process process) {
        this._process = process;
        this.initComponents();
        this.jPanelOutputSelect.add(new MX60MidiOutListPanel());
        this._jTableSkip = new JTableWithFooter(this.jPanel1);
        this.resetTableModel();
        this._jTableSkip.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MX60View.this._jTableSkip.isEnabled()) {
                    MX60View.this.jTableSkip_MouseClicked(evt);
                }
            }
        });
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(0);
        for (int i = 1; i < this._jTableSkip.getColumnCount(); ++i) {
            TableColumn col = this._jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        this.jCheckBoxUseSkip.setSelected(this._process.isUsingThisRecipe());
        this._jTableSkip.setEnabled(this._process.isUsingThisRecipe());
        this.jPanel2.add(this._process.getPatchBay().getReceiverView());
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanelOutputSelect = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jCheckBoxUseSkip = new JCheckBox();
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane2.setDividerLocation(250);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane1.setDividerLocation(300);
        this.jPanelOutputSelect.setBorder(BorderFactory.createTitledBorder("1.Assign Output"));
        this.jPanelOutputSelect.setLayout(new BoxLayout(this.jPanelOutputSelect, 2));
        this.jSplitPane1.setLeftComponent(this.jPanelOutputSelect);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("2. Port Forwarding"));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.jSplitPane2.setTopComponent(this.jSplitPane1);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("3.Skip Which"));
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jCheckBoxUseSkip.setText("Use This Recipe");
        this.jCheckBoxUseSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jCheckBoxUseSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jCheckBoxUseSkip, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel3);
        this.add(this.jSplitPane2);
    }

    private void jCheckBoxUseSkipActionPerformed(ActionEvent evt) {
        this._process.setUsingThisRecipe(this.jCheckBoxUseSkip.isSelected());
        this._jTableSkip.setEnabled(this.jCheckBoxUseSkip.isSelected());
    }

    public synchronized TableModel createSkipTableModel() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("");
        for (int i = 0; i < 16; ++i) {
            model.addColumn(MXUtilMidi.nameOfPortShort(i));
        }
        int row = 0;
        while (true) {
            MX60Data cfr_ignored_0 = this._process._data;
            if (row >= 10) break;
            Vector<String> line = new Vector<String>();
            MX60Data cfr_ignored_1 = this._process._data;
            line.add(MX60Data.typeNames[row]);
            for (int delivery = 0; delivery < 16; ++delivery) {
                int type = row + 1;
                if (this._process._data.isSkip(delivery, type)) {
                    line.add("Skip");
                    continue;
                }
                line.add("");
            }
            model.addRow(line);
            ++row;
        }
        return model;
    }

    private void jTableSkip_MouseClicked(MouseEvent evt) {
        int row = this._jTableSkip.rowAtPoint(evt.getPoint());
        int column = this._jTableSkip.columnAtPoint(evt.getPoint());
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)this._jTableSkip.getModel();
        if (type >= 1) {
            MX60Data cfr_ignored_0 = this._process._data;
            if (type <= 10 && port >= 0 && port < 16) {
                if (this._process._data.isSkip(port, type)) {
                    this._process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                } else {
                    this._process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }

    public void resetTableModel() {
        this._jTableSkip.setModel(this.createSkipTableModel());
        this._jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }
}

