/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx60output;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx10input.MX10Data;
import jp.synthtarou.midimixer.mx20patchbay.MX20Process;
import jp.synthtarou.midimixer.mx60output.MX60Data;
import jp.synthtarou.midimixer.mx60output.MX60View;

public class MX60Process
extends MXReceiver
implements MXSettingTarget {
    public MX60Data _data = new MX60Data();
    private MX60View _view;
    private MX20Process _patchBay = new MX20Process(false);
    MXSetting _setting;

    public MX60Process() {
        this._view = new MX60View(this);
        this._setting = new MXSetting("OutputSkip");
        this._setting.setTarget(this);
        this._patchBay.setNextReceiver(new MXReceiver(){

            @Override
            public String getReceiverName() {
                return "dummy";
            }

            @Override
            public JComponent getReceiverView() {
                return null;
            }

            @Override
            public void processMXMessage(MXMessage message) {
                if (MX60Process.this.isUsingThisRecipe() && MX60Process.this._data.isMessageToSkip(message)) {
                    return;
                }
                MX60Process.this.sendToNext(message);
            }
        });
    }

    public void readSettings() {
        this._setting.readFile();
        this._patchBay.readSettings();
    }

    @Override
    public void processMXMessage(MXMessage message) {
        this._patchBay.processMXMessage(message);
    }

    @Override
    public String getReceiverName() {
        return "Output Dispatcher";
    }

    @Override
    public JComponent getReceiverView() {
        return this._view;
    }

    public MX20Process getPatchBay() {
        return this._patchBay;
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX60Process mX60Process = this;
                if (j >= mX60Process._data.countOfTypes()) continue block0;
                String name = MX60Data.typeNames[j];
                boolean set = setting.getSettingAsBoolean(prefix + name, false);
                this._data.setSkip(port, j, set);
                ++j;
            }
        }
        this._view.resetTableModel();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX60Process mX60Process = this;
                if (j >= mX60Process._data.countOfTypes()) continue block0;
                boolean set = this._data.isSkip(port, j);
                String name = MX60Data.typeNames[j];
                setting.setSetting(prefix + name, set);
                ++j;
            }
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        String prefix = "Setting[].";
        for (String text : MX10Data.typeNames) {
            setting.register(prefix + text);
        }
    }
}

