/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx30controller.MGCircle;
import jp.synthtarou.midimixer.mx30controller.MGPad;
import jp.synthtarou.midimixer.mx30controller.MGSlider;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MX30View;
import jp.synthtarou.midimixer.mx30controller.MX32MixerData;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;

public class MX30Process
extends MXReceiver
implements MXSettingTarget {
    private MX30View _rootView;
    private MX32MixerProcess[] _pageProcess;
    boolean _editingControl;
    MXSetting _setting = new MXSetting("MixingGlobal");
    int focus_port;
    int focus_type = -1;
    int focus_row;
    int focus_column;
    Color colorBack = null;
    Color colorEdit = null;
    Color colorFocus = null;
    private boolean[] _activeKnob;
    private boolean[] _activePad;
    private int _activeLines;

    public MX30Process() {
        this._setting.setTarget(this);
        this.prepareActiveSlider();
        this._rootView = new MX30View(this);
        this._pageProcess = new MX32MixerProcess[16];
        for (int i = 0; i < 16; ++i) {
            this._pageProcess[i] = new MX32MixerProcess(this, i);
        }
    }

    public void readSettings() {
        this._setting.readFile();
        for (int port = 0; port < 16; ++port) {
            this._pageProcess[port].readSettings();
            MX32MixerProcess proc = this._pageProcess[port];
            this._rootView.addPage(port, proc);
            proc.setNextReceiver(new MXReceiver(){

                @Override
                public String getReceiverName() {
                    return null;
                }

                @Override
                public JComponent getReceiverView() {
                    return null;
                }

                @Override
                public void processMXMessage(MXMessage message) {
                    MX30Process.this.sendToNext(message);
                }
            });
        }
        this.globalContollerHidden();
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("ActiveCircle");
        setting.register("ActiveLine");
        setting.register("ActivePad");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        String circle = setting.getSetting("ActiveCircle");
        if (circle == null) {
            circle = "1, 2, 3, 4";
        }
        ArrayList<String> circleList = new ArrayList<String>();
        MXUtil.split(circle, circleList, ',');
        this._activeKnob = new boolean[4];
        for (String str : circleList) {
            str = str.trim();
            try {
                this._activeKnob[Integer.parseInt((String)str) - 1] = true;
            }
            catch (Exception exception) {}
        }
        String line = setting.getSetting("ActiveLine");
        int lineNum = 17;
        try {
            if (line != null) {
                lineNum = Integer.parseInt(line.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._activeLines = lineNum;
        String pad = setting.getSetting("ActivePad");
        if (pad == null) {
            pad = "1, 2, 3";
        }
        ArrayList<String> padList = new ArrayList<String>();
        MXUtil.split(pad, padList, ',');
        this._activePad = new boolean[4];
        for (String str : padList) {
            str = str.trim();
            try {
                this._activePad[Integer.parseInt((String)str) - 1] = true;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        setting.clearValue();
        StringBuffer circle = new StringBuffer();
        for (int i = 0; i < this._activeKnob.length; ++i) {
            if (!this._activeKnob[i]) continue;
            if (circle.length() != 0) {
                circle.append(",");
            }
            circle.append(i + 1);
        }
        StringBuffer pad = new StringBuffer();
        for (int i = 0; i < this._activePad.length; ++i) {
            if (!this._activePad[i]) continue;
            if (pad.length() != 0) {
                pad.append(",");
            }
            pad.append(i + 1);
        }
        setting.setSetting("ActiveCircle", circle.toString());
        setting.setSetting("ActiveLine", this._activeLines);
        setting.setSetting("ActivePad", pad.toString());
    }

    public MX32MixerProcess getPage(int i) {
        return this._pageProcess[i];
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (!this.isUsingThisRecipe()) {
            this.sendToNext(message);
            return;
        }
        int port = message.getPort();
        this._pageProcess[port].processMXMessage(message);
    }

    @Override
    public String getReceiverName() {
        return "Kontrolls";
    }

    @Override
    public JComponent getReceiverView() {
        return this._rootView;
    }

    public boolean isFocusControl(MGStatus status) {
        return status.getPort() == this.focus_port && status.getUiType() == this.focus_type && status.getRow() == this.focus_row && status.getColumn() == this.focus_column;
    }

    public boolean isFocusEditing(MGStatus status) {
        if (!this.isFocusControl(status)) {
            return false;
        }
        return this._editingControl;
    }

    public void showTextForFocus(int type, int port, int row, int column) {
        String value = "(NONE)";
        try {
            if (this.colorBack == null) {
                this.colorBack = new JLabel().getBackground();
                this.colorEdit = Color.orange;
                this.colorFocus = Color.cyan;
            }
            if (this.focus_type > 0) {
                Color c = MXStatic.sliderColor(this.focus_column);
                MX32MixerData focus_data = this.getPage((int)this.focus_port)._data;
                switch (this.focus_type) {
                    case 2: {
                        MGSlider slider = focus_data.getSlider(this.focus_row, this.focus_column);
                        MXUtil.backgroundRecursive(slider, c);
                        break;
                    }
                    case 1: {
                        MGCircle circle = focus_data.getCircle(this.focus_row, this.focus_column);
                        MXUtil.backgroundRecursive(circle, c);
                        break;
                    }
                    case 3: {
                        MGPad drum = focus_data.getDrumPad(this.focus_row, this.focus_column);
                        MXUtil.backgroundRecursive(drum, c);
                    }
                }
            }
            MX32MixerData focus_data = this.getPage((int)port)._data;
            switch (type) {
                case 2: {
                    MGSlider slider = focus_data.getSlider(row, column);
                    value = focus_data.getSliderStatus(row, column).toString();
                    if (this._editingControl) {
                        MXUtil.backgroundRecursive(slider, this.colorEdit);
                        break;
                    }
                    MXUtil.backgroundRecursive(slider, this.colorFocus);
                    break;
                }
                case 1: {
                    MGCircle circle = focus_data.getCircle(row, column);
                    value = focus_data.getCircleStatus(row, column).toString();
                    if (this._editingControl) {
                        MXUtil.backgroundRecursive(circle, this.colorEdit);
                        break;
                    }
                    MXUtil.backgroundRecursive(circle, this.colorFocus);
                    break;
                }
                case 3: {
                    MGPad drum = focus_data.getDrumPad(row, column);
                    value = focus_data.getDrumPadStatus(row, column).toString();
                    if (this._editingControl) {
                        MXUtil.backgroundRecursive(drum, this.colorEdit);
                        break;
                    }
                    MXUtil.backgroundRecursive(drum, this.colorFocus);
                    break;
                }
                default: {
                    value = "Unknown";
                }
            }
            this.focus_type = type;
            this.focus_port = port;
            this.focus_row = row;
            this.focus_column = column;
        }
        catch (Throwable e) {
            value = "ERR";
            e.printStackTrace();
        }
        this._pageProcess[port]._view.setFocusString(value);
    }

    public void goNextFocus(final int port, final int keyCode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX30Process.this.goNextFocus(port, keyCode);
                }
            });
            return;
        }
        int type = this.focus_type;
        int row = this.focus_row;
        int column = this.focus_column;
        if (type < 0) {
            type = 0;
            row = 0;
            column = 0;
        } else {
            block0 : switch (keyCode) {
                case 38: {
                    if (row > 0) {
                        --row;
                        break;
                    }
                    switch (--type) {
                        case 0: {
                            type = 1;
                            break;
                        }
                        case 1: {
                            row = 3;
                            break;
                        }
                        case 2: {
                            row = 0;
                            break;
                        }
                        case 3: {
                            row = 1;
                        }
                    }
                    break;
                }
                case 40: {
                    ++row;
                    switch (type) {
                        case 1: {
                            if (row < 4) break;
                            row = 0;
                            type = 2;
                            break;
                        }
                        case 2: {
                            if (row < 1) break;
                            row = 0;
                            type = 3;
                            break;
                        }
                        case 3: {
                            if (row < 2) break;
                            --row;
                        }
                    }
                    break;
                }
                case 37: {
                    if (--column >= 0) break;
                    column = 0;
                    break;
                }
                case 39: {
                    if (++column < 17) break;
                    --column;
                    break;
                }
                case 8: 
                case 10: 
                case 32: {
                    MX32MixerData focus_data = this.getPage((int)port)._data;
                    switch (type) {
                        case 2: {
                            MGSlider slider = focus_data.getSlider(this.focus_row, this.focus_column);
                            switch (keyCode) {
                                case 32: {
                                    slider.increment(new MXTraceNumber());
                                    break block0;
                                }
                                case 8: {
                                    slider.decriment(new MXTraceNumber());
                                    break block0;
                                }
                                case 10: {
                                    slider.editContoller();
                                }
                            }
                            break block0;
                        }
                        case 1: {
                            MGCircle circle = focus_data.getCircle(this.focus_row, this.focus_column);
                            switch (keyCode) {
                                case 32: {
                                    circle.increment(new MXTraceNumber());
                                    break block0;
                                }
                                case 8: {
                                    circle.decriment(new MXTraceNumber());
                                    break block0;
                                }
                                case 10: {
                                    circle.editContoller();
                                }
                            }
                            break block0;
                        }
                        case 3: {
                            MGPad drum = focus_data.getDrumPad(this.focus_row, this.focus_column);
                            switch (keyCode) {
                                case 32: {
                                    drum.increment(null, new MXTraceNumber());
                                    break block0;
                                }
                                case 8: {
                                    drum.decriment(null, new MXTraceNumber());
                                    break block0;
                                }
                                case 10: {
                                    drum.editContoller();
                                }
                            }
                            break block0;
                        }
                    }
                }
            }
        }
        this.showTextForFocus(type, port, row, column);
    }

    public void enterEditMode(boolean flag) {
        if (flag) {
            this._editingControl = true;
            this._rootView.lockAnothereTabs(true);
            MXMain.getMain().getMainWindow().setTitle("*** EDIT CONTROl MODE ***");
        } else {
            this._editingControl = false;
            this._rootView.lockAnothereTabs(false);
            MXMain.getMain().getMainWindow().setTitle("MIX Recipe 0.25");
        }
    }

    protected void prepareActiveSlider() {
        if (this._activeLines == 0) {
            int i;
            this._activeLines = 17;
            this._activeKnob = new boolean[4];
            for (i = 0; i < this._activeKnob.length; ++i) {
                this._activeKnob[i] = true;
            }
            this._activePad = new boolean[3];
            for (i = 0; i < this._activePad.length; ++i) {
                this._activePad[i] = true;
            }
        }
    }

    public int getActiveLines() {
        return this._activeLines;
    }

    public void setActiveLines(int _activeLines) {
        this._activeLines = _activeLines;
    }

    public boolean isKnobActive(int r) {
        return this._activeKnob[r];
    }

    public void setKnobActive(int r, boolean active) {
        this._activeKnob[r] = active;
    }

    public boolean isPadActive(int r) {
        return this._activePad[r];
    }

    public void setPadActive(int r, boolean active) {
        this._activePad[r] = active;
    }

    public void globalContollerHidden() {
        for (int t = 0; t < this._pageProcess.length; ++t) {
            this._pageProcess[t]._view.globalControllerHidden();
        }
    }
}

