/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.mx20patchbay.MX20Data;
import jp.synthtarou.midimixer.mx20patchbay.MX20Process;

public class MX20View_OLD
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX20View_OLD.class);
    JTableWithFooter jTableChMapping;
    MX20Process _process;
    private JCheckBox jCheckBoxUseRoute;
    private JPanel jPanelChannelMapping;

    public MX20View_OLD(MX20Process process) {
        this._process = process;
        this.initComponents();
        this.setMinimumSize(new Dimension(100, 100));
        this.jTableChMapping = new JTableWithFooter(this.jPanelChannelMapping);
        TableModel model = this.createTableModel();
        this.jTableChMapping.setModel(model);
        this.jCheckBoxUseRoute.setSelected(this._process.isUsingThisRecipe());
        this.jTableChMapping.setEnabled(this._process.isUsingThisRecipe());
        this.jTableChMapping.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MX20View_OLD.this.jTableChMapping.isEnabled()) {
                    MX20View_OLD.this.jTableChMapping_MousePressed(evt);
                }
            }
        });
    }

    public void updateModel() {
        TableModel model = this.createTableModel();
        this.jTableChMapping.setModel(model);
    }

    private void initComponents() {
        this.jCheckBoxUseRoute = new JCheckBox();
        this.jPanelChannelMapping = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jCheckBoxUseRoute.setText("Use This Recipe");
        this.jCheckBoxUseRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX20View_OLD.this.jCheckBoxUseRouteActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jCheckBoxUseRoute, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelChannelMapping, gridBagConstraints);
    }

    private void jCheckBoxUseRouteActionPerformed(ActionEvent evt) {
        this._process.setUsingThisRecipe(this.jCheckBoxUseRoute.isSelected());
        this.jTableChMapping.setEnabled(this.jCheckBoxUseRoute.isSelected());
    }

    public void jTableChMapping_MousePressed(MouseEvent evt) {
        int row = this.jTableChMapping.rowAtPoint(evt.getPoint());
        int column = this.jTableChMapping.columnAtPoint(evt.getPoint());
        int port = column - 1;
        int delivery = 16 - row - 1;
        if (port >= 0) {
            try {
                MX20Data data = this._process.getData();
                if (!data.isEnabled(port, delivery)) {
                    data.set(port, delivery, true);
                } else {
                    data.set(port, delivery, false);
                }
                this.updateModel();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex > 0) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        String inName = "";
        String outName = "";
        if (this._process.isTypeInput()) {
            inName = "In-Device ";
            outName = "Internal ";
        } else {
            inName = "Internal ";
            outName = "Out-Device ";
        }
        model.addColumn("");
        for (int i = 0; i < 16; ++i) {
            model.addColumn(inName + MXUtilMidi.nameOfPortShort(i));
        }
        for (int delivery = 15; delivery >= 0; --delivery) {
            Vector<Object> line = new Vector<Object>();
            line.add(outName + MXUtilMidi.nameOfPortShort(delivery));
            for (int port = 0; port < 16; ++port) {
                if (this._process.getData().isEnabled(port, delivery)) {
                    line.add(Boolean.TRUE);
                    continue;
                }
                line.add(Boolean.FALSE);
            }
            model.addRow(line);
        }
        return model;
    }
}

