/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx20patchbay.MX20Data;
import jp.synthtarou.midimixer.mx20patchbay.MX20View;

public class MX20Process
extends MXReceiver
implements MXSettingTarget {
    private static final MXDebugLines _debug = new MXDebugLines(MX20Process.class);
    MX20Data _data;
    private MX20View _view;
    private MXSetting _setting;
    private boolean _typeInput = false;

    public boolean isTypeInput() {
        return this._typeInput;
    }

    public MX20Process(boolean typeInput) {
        this._typeInput = typeInput;
        this._data = new MX20Data();
        this._view = new MX20View(this);
        this._setting = typeInput ? new MXSetting("InputPortPatching") : new MXSetting("OutputPortPatching");
        this._setting.setTarget(this);
    }

    public void readSettings() {
        this._setting.readFile();
        if (this._setting.isEmpty()) {
            this.initStraight();
        }
        this._view.setupViewFromModel();
    }

    public MX20Data getData() {
        return this._data;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (!this.isUsingThisRecipe()) {
            this.sendToNext(message);
            return;
        }
        int port = message.getPort();
        boolean proc = false;
        for (int j = 0; j < 16; ++j) {
            if (!this._data.isEnabled(port, j)) continue;
            if (port == j) {
                proc = true;
                this.sendToNext(message);
                continue;
            }
            proc = true;
            MXMessage message2 = MXMessageFactory.fromClone(message._traceNumber, message);
            message2.setPort(j);
            this.sendToNext(message2);
        }
    }

    public void initStraight() {
        for (int i = 0; i < 16; ++i) {
            this._data.set(i, i, true);
        }
        this._view.setupViewFromModel();
    }

    public void initStraightAndAllLast() {
        int i;
        for (i = 0; i < 16; ++i) {
            this._data.set(i, i, true);
        }
        for (i = 0; i < 16; ++i) {
            this._data.set(i, 15, true);
        }
        this._view.setupViewFromModel();
    }

    @Override
    public String getReceiverName() {
        if (this._typeInput) {
            return "Input Patch";
        }
        return "Output Patch";
    }

    @Override
    public JPanel getReceiverView() {
        return this._view;
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        for (int i = 0; i < 16; ++i) {
            setting.register("From" + MXUtilMidi.nameOfPortShort(i));
        }
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        this._data.clear();
        for (int port = 0; port < 16; ++port) {
            String[] array;
            String text = setting.getSetting("From" + MXUtilMidi.nameOfPortShort(port));
            if (text == null || (array = text.split("[ ,]+")).length == 0) continue;
            for (String elem : array) {
                try {
                    int to = Integer.parseInt(elem);
                    this._data.set(port, to, true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        setting.clearValue();
        for (int port = 0; port < 16; ++port) {
            StringBuffer text = new StringBuffer();
            for (int to = 0; to < 16; ++to) {
                if (!this._data.isEnabled(port, to)) continue;
                if (text.length() != 0) {
                    text.append(",");
                }
                text.append(String.valueOf(to));
            }
            setting.setSetting("From" + MXUtilMidi.nameOfPortShort(port), text.toString());
        }
    }
}

