/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx12masterkeys;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXTraceNumber;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.MXButtonUILabel;
import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;
import jp.synthtarou.midimixer.libs.swing.MXSliderUIForTablet;
import jp.synthtarou.midimixer.mx12masterkeys.MX12MasterPanelEditor;
import jp.synthtarou.midimixer.mx12masterkeys.MX12Process;

public class MX12MasterkeysPanel
extends JPanel {
    MX12Process _process;
    MXPianoComponent _piano;
    MXWrapList<Integer> _watchPort = MXUtilMidi.createPortInput(false);
    MXWrapList<Integer> _watchChannel = MXUtilMidi.createChannel(false);
    int _valuePitch = -1;
    int _valueModulation = -1;
    boolean _beforeBuild = true;
    boolean _updateLock = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JLabel jLabelEdit;
    private JLabel jLabelInfo1;
    private JLabel jLabelInfo2;
    private JPanel jPanelOutput;
    private JScrollPane jScrollPane1;
    private JSlider jSliderModwheel;
    private JSlider jSliderPitch;

    public static void main(String[] args) {
        MXDebugLines.globalSwitchOn();
        JFrame win = new JFrame("Piano");
        win.setDefaultCloseOperation(3);
        Insets ins = win.getInsets();
        win.setSize(500 + ins.left + ins.right, 500 + ins.top + ins.bottom);
        win.setLayout(new GridLayout(1, 1));
        MX12Process proc = new MX12Process();
        MX12MasterkeysPanel keys = new MX12MasterkeysPanel(proc);
        win.add(keys);
        win.setVisible(true);
    }

    public MX12MasterkeysPanel(MX12Process process) {
        this.initComponents();
        this._process = process;
        this.jSliderPitch.setMinimum(0);
        this.jSliderPitch.setMaximum(16383);
        this.jSliderPitch.setValue(8192);
        new MXSliderUIForTablet(this.jSliderPitch);
        this.jSliderPitch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MX12MasterkeysPanel.this.setPitchBend(8192);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                MX12MasterkeysPanel.this.setPitchBend(8192);
            }
        });
        this.jSliderPitch.setMajorTickSpacing(2048);
        this.jSliderPitch.setMinorTickSpacing(512);
        this.jSliderPitch.setPaintTicks(true);
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        table.put(0, new JLabel("0"));
        table.put(8192, new JLabel("8192"));
        table.put(16383, new JLabel("16383"));
        this.jSliderPitch.setLabelTable(table);
        this.jSliderPitch.setPaintLabels(true);
        this.jSliderModwheel.setMinimum(0);
        this.jSliderModwheel.setMaximum(127);
        this.jSliderModwheel.setValue(0);
        this.jSliderModwheel.setMajorTickSpacing(32);
        this.jSliderModwheel.setPaintTicks(true);
        Hashtable<Integer, JLabel> table2 = new Hashtable<Integer, JLabel>();
        table2.put(0, new JLabel("0"));
        table2.put(127, new JLabel("127"));
        this.jSliderModwheel.setLabelTable(table2);
        this.jSliderModwheel.setPaintLabels(true);
        this._piano = new MXPianoComponent();
        this._piano.setNoteRange(0, 11);
        this._piano.setMinimumSize(new Dimension(1800, 1));
        this._piano.setPreferredSize(new Dimension(1800, 120));
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setViewportView(this._piano);
        this._piano.setHandler(new MXPianoComponent.Handler(){

            @Override
            public void noteOn(int note) {
                MXMessage message = MXMessageFactory.fromShortMessage(MX12MasterkeysPanel.this._process.getMousePort(), new MXTraceNumber(), 144 + MX12MasterkeysPanel.this._process.getMouseChannel(), note, MX12MasterkeysPanel.this._process.getMouseVelocity());
                MX12MasterkeysPanel.this._process.mouseMessage(message);
            }

            @Override
            public void noteOff(int note) {
                MXMessage message = MXMessageFactory.fromShortMessage(MX12MasterkeysPanel.this._process.getMousePort(), new MXTraceNumber(), 128 + MX12MasterkeysPanel.this._process.getMouseChannel(), note, 0);
                MX12MasterkeysPanel.this._process.mouseMessage(message);
            }

            @Override
            public void selectionChanged() {
            }
        });
        String title = "Select Output to Connect.";
        new MXSliderUIForTablet(this.jSliderModwheel);
        new MXButtonUILabel(this.jLabelEdit, new Runnable(){

            @Override
            public void run() {
                Window w = SwingUtilities.getWindowAncestor(MX12MasterkeysPanel.this);
                JFrame frame = MXMain.getMain().getMainWindow();
                if (w instanceof JFrame) {
                    frame = (JFrame)w;
                }
                MX12MasterPanelEditor.showAsDialog(frame, MX12MasterkeysPanel.this._process, true);
                MX12MasterkeysPanel.this.updateViewForSettingChange();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MX12MasterkeysPanel.this.updateViewForSettingChange();
            }
        });
        this._beforeBuild = false;
    }

    public void scrollToCenter() {
        Dimension scrollSize = this.jScrollPane1.getSize();
        Dimension pianoSize = this._piano.getSize();
        Rectangle rect = new Rectangle((int)(pianoSize.getWidth() - scrollSize.getWidth()) / 2, 0, (int)scrollSize.getWidth(), 50);
        this.jScrollPane1.getViewport().scrollRectToVisible(rect);
    }

    public void updateViewForSettingChange() {
        StringBuffer info = new StringBuffer();
        info.append(this._process.getReceiverName() + ", ");
        info.append("Port " + MXUtilMidi.nameOfPortInput(this._process.getMousePort()) + ", ");
        info.append("Channel " + (this._process.getMouseChannel() + 1));
        this.jLabelInfo1.setText(info.toString());
        info = new StringBuffer();
        if (this._process.isAcceptThisPageSignal()) {
            info.append("Process This page's Signal ");
            if (this._process.isAcceptInputPanelSignal()) {
                info.append(", And ");
            }
        } else if (this._process.isAcceptInputPanelSignal()) {
            info.append("And Process ");
        }
        if (this._process.isAcceptInputPanelSignal()) {
            info.append("Input Panel's Signal ");
            if (this._process.isOverwriteInputChannel()) {
                info.append("( With Re-Adjust Ch/Port ) ");
            }
        }
        this.jLabelInfo2.setText(info.toString());
    }

    public void setPitchBend(final int value) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX12MasterkeysPanel.this.setPitchBend(value);
                }
            });
            return;
        }
        if (this._valuePitch != value) {
            this._valuePitch = value;
            this._updateLock = true;
            this.jSliderPitch.setValue(value);
            this._updateLock = false;
        }
    }

    public void setModulatoinWheel(final int value) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX12MasterkeysPanel.this.setModulatoinWheel(value);
                }
            });
            return;
        }
        if (this._valueModulation != value) {
            this._valueModulation = value;
            this._updateLock = true;
            this.jSliderModwheel.setValue(value);
            this._updateLock = false;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jSliderPitch = new JSlider();
        this.jSliderModwheel = new JSlider();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelOutput = new JPanel();
        this.jLabelEdit = new JLabel();
        this.jLabelInfo1 = new JLabel();
        this.jLabelInfo2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jSliderPitch.setOrientation(1);
        this.jSliderPitch.setToolTipText("Pitch");
        this.jSliderPitch.setBorder(BorderFactory.createBevelBorder(0));
        this.jSliderPitch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MX12MasterkeysPanel.this.jSliderPitchStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jSliderPitch, gridBagConstraints);
        this.jSliderModwheel.setOrientation(1);
        this.jSliderModwheel.setBorder(BorderFactory.createBevelBorder(0));
        this.jSliderModwheel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MX12MasterkeysPanel.this.jSliderModwheelStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jSliderModwheel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanelOutput.setBorder(BorderFactory.createTitledBorder("Output"));
        this.jPanelOutput.setLayout(new GridBagLayout());
        this.jLabelEdit.setText("Config");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 13;
        this.jPanelOutput.add((Component)this.jLabelEdit, gridBagConstraints);
        this.jLabelInfo1.setText("Info1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelOutput.add((Component)this.jLabelInfo1, gridBagConstraints);
        this.jLabelInfo2.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelOutput.add((Component)this.jLabelInfo2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanelOutput, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jSliderModwheelStateChanged(ChangeEvent evt) {
        int value;
        if (this._beforeBuild) {
            return;
        }
        if (this._updateLock) {
            return;
        }
        this._valueModulation = value = this.jSliderModwheel.getValue();
        MXMain mXMain = MXMain.getMain();
        synchronized (mXMain) {
            MXMessage msg = MXMessageFactory.fromShortMessage(this._process.getMousePort(), new MXTraceNumber(), 176 + this._process.getMouseChannel(), 1, 0);
            msg.setValue(value);
            this._process.mouseMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jSliderPitchStateChanged(ChangeEvent evt) {
        int value;
        if (this._beforeBuild) {
            return;
        }
        if (this._updateLock) {
            return;
        }
        this._valuePitch = value = this.jSliderPitch.getValue();
        MXMain mXMain = MXMain.getMain();
        synchronized (mXMain) {
            MXMessage msg = MXMessageFactory.fromShortMessage(this._process.getMousePort(), new MXTraceNumber(), 224 + this._process.getMouseChannel(), 0, 0);
            msg.setValue(value);
            this._process.mouseMessage(msg);
        }
    }

    public boolean isOwnerwindowVisible() {
        try {
            Container cont = MXUtil.getOwnerWindow(this);
            if (cont == null) {
                return true;
            }
            return cont.isVisible();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void showAsWindow() {
        JFrame newFrame = new JFrame();
        newFrame.setTitle("Master Keys (MIX Recipe)");
        newFrame.pack();
        newFrame.getContentPane().add(this);
        this.setPreferredSize(new Dimension(1000, 250));
        newFrame.pack();
        MXUtil.centerWindow(newFrame);
        newFrame.setVisible(true);
        this.scrollToCenter();
    }
}

