/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx11vcurve;

public class MX11Data {
    int _portCount = 16;
    static int[] DEFAULT_CURVE = new int[]{1, 25, 50, 75, 100, 127};
    int[][] _vc = new int[this._portCount][];

    public MX11Data() {
        for (int i = 0; i < this._portCount; ++i) {
            this._vc[i] = new int[DEFAULT_CURVE.length];
            for (int j = 0; j < DEFAULT_CURVE.length; ++j) {
                this._vc[i][j] = DEFAULT_CURVE[j];
            }
        }
    }

    public int portCount() {
        return this._portCount;
    }

    public int curveCount() {
        return DEFAULT_CURVE.length;
    }

    public int curveDefault(int pos) {
        return DEFAULT_CURVE[pos];
    }

    public int curveValue(int port, int pos) {
        return this._vc[port][pos];
    }

    public void setCurveValue(int port, int pos, int value) {
        this._vc[port][pos] = value;
    }

    public int transform(int port, int velocity) {
        if (velocity == 0) {
            return 0;
        }
        if (velocity >= 128) {
            return velocity;
        }
        int[] curve = this._vc[port];
        for (int j = 0; j < curve.length - 1; ++j) {
            int prev = DEFAULT_CURVE[j];
            int next = DEFAULT_CURVE[j + 1];
            int prevTo = curve[j];
            int nextTo = curve[j + 1];
            if (velocity == prev) {
                return prevTo;
            }
            if (velocity == next) {
                return nextTo;
            }
            if (velocity < prev + 1 || velocity > next) continue;
            if (prev == prevTo && next == nextTo) {
                return velocity;
            }
            double width = next - prev;
            double widthTo = nextTo - prevTo;
            double v = velocity;
            double step = v - (double)prev;
            double percent = step / width;
            double stepTo = widthTo * percent;
            return (int)stepTo + prevTo;
        }
        return velocity;
    }
}

