/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx10input;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.mx10input.MX10Data;
import jp.synthtarou.midimixer.mx10input.MX10MidiInListPanel;
import jp.synthtarou.midimixer.mx10input.MX10Process;

public class MX10View
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX10View.class);
    MX10Process _process;
    MX10MidiInListPanel _inPanel;
    JTableWithColumnHeader _jTableSkip;
    private JCheckBox jCheckBoxUseMessageFilter;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanelInputSelect;
    private JPanel jPanelSkip;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;

    public MX10View(MX10Process process) {
        this._process = process;
        this.initComponents();
        this._inPanel = new MX10MidiInListPanel();
        this.jPanelInputSelect.add(this._inPanel);
        this._jTableSkip = new JTableWithFooter(this.jPanel1);
        this.resetTableModel();
        this._jTableSkip.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MX10View.this._jTableSkip.isEnabled()) {
                    MX10View.this.jTableSkip_MouseClicked(evt);
                }
            }
        });
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(0);
        for (int i = 1; i < this._jTableSkip.getColumnCount(); ++i) {
            TableColumn col = this._jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        this.jCheckBoxUseMessageFilter.setSelected(this._process.isUseMessageFilter());
        this._jTableSkip.setEnabled(this._process.isUseMessageFilter());
        this.jPanel4.add(this._process._patchBay.getReceiverView());
    }

    private void jTableSkip_MouseClicked(MouseEvent evt) {
        int row = this._jTableSkip.rowAtPoint(evt.getPoint());
        int column = this._jTableSkip.columnAtPoint(evt.getPoint());
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)this._jTableSkip.getModel();
        if (type >= 1) {
            MX10Data cfr_ignored_0 = this._process._data;
            if (type <= 10 && port >= 0 && port < 16) {
                if (this._process._data.isSkip(port, type)) {
                    this._process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                } else {
                    this._process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanelInputSelect = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanelSkip = new JPanel();
        this.jCheckBoxUseMessageFilter = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane2.setDividerLocation(240);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane1.setDividerLocation(400);
        this.jPanelInputSelect.setBorder(BorderFactory.createTitledBorder("1.Assign Input"));
        this.jPanelInputSelect.setLayout(new BoxLayout(this.jPanelInputSelect, 2));
        this.jSplitPane1.setLeftComponent(this.jPanelInputSelect);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("2.Port Forwarding"));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        this.jSplitPane1.setBottomComponent(this.jPanel4);
        this.jSplitPane2.setLeftComponent(this.jSplitPane1);
        this.jPanelSkip.setBorder(BorderFactory.createTitledBorder("3.Skip Which"));
        this.jPanelSkip.setLayout(new GridBagLayout());
        this.jCheckBoxUseMessageFilter.setText("Use This Recipe");
        this.jCheckBoxUseMessageFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX10View.this.jCheckBoxUseMessageFilterActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanelSkip.add((Component)this.jCheckBoxUseMessageFilter, gridBagConstraints);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSkip.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanelSkip);
        this.add(this.jSplitPane2);
    }

    private void jCheckBoxUseMessageFilterActionPerformed(ActionEvent evt) {
        this._process.setUseMesssageFilter(this.jCheckBoxUseMessageFilter.isSelected());
    }

    public synchronized TableModel createSkipTableModel(MX10Data data) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("");
        for (int i = 0; i < 16; ++i) {
            model.addColumn(MXUtilMidi.nameOfPortShort(i));
        }
        int row = 0;
        while (true) {
            MX10Data cfr_ignored_0 = this._process._data;
            if (row >= 10) break;
            Vector<String> line = new Vector<String>();
            line.add(MX10Data.typeNames[row]);
            for (int delivery = 0; delivery < 16; ++delivery) {
                int type = row + 1;
                if (data.isSkip(delivery, type)) {
                    line.add("Skip");
                    continue;
                }
                line.add("");
            }
            model.addRow(line);
            ++row;
        }
        Vector<String> line = new Vector<String>();
        line.add("");
        for (int i = 0; i < 16; ++i) {
            line.add(MXUtilMidi.nameOfPortShort(i));
        }
        return model;
    }

    public void resetTableModel() {
        this._jTableSkip.setModel(this.createSkipTableModel(this._process._data));
        this._jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }
}

