/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;
import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;

public class MX00PianoPanel
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX00PianoPanel.class);
    private static final PDFile _moduleInfo = PDFileManager.getManager().get(0);
    MXPianoComponent _keys;
    int _channel;

    public MX00PianoPanel(MXPianoComponent keys) {
        this.initComponents();
        this._keys = keys;
        this.add(this._keys);
    }

    public void autoAdjustHeight(int width) {
        this._keys.paintOnBuffer(null);
        int newHeight = this._keys.getAdjustedHeight(width);
        Dimension d = new Dimension(width, newHeight);
        this.setPreferredSize(d);
    }

    public MXPianoComponent getKeys() {
        return this._keys;
    }

    public void setChannel(int ch) {
        this._channel = ch;
    }

    public int getChannel() {
        return this._channel;
    }

    public void updateProgramNumber(int program) {
        String name = _moduleInfo.getModule().simpleGetName(program, -1, -1);
        this.setBorder(BorderFactory.createTitledBorder("TR " + (this._channel + 1) + " " + name + "(" + program + ")"));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("abc"));
        this.setLayout(new BoxLayout(this, 2));
    }
}

