/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;

public class MX00DrumPadPanel
extends JPanel {
    private static final MXDebugLines _debug = new MXDebugLines(MX00DrumPadPanel.class);
    private static final PDFile _moduleInfo = PDFileManager.getManager().get(0);
    JToggleButton[] listDrums = new JToggleButton[256];
    ArrayList<ArrayList<JToggleButton>> layout;
    long timer;

    public MX00DrumPadPanel() {
        this.initComponents();
        if (!SwingUtilities.isEventDispatchThread()) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
    }

    public void buttonLayout(JToggleButton btn) {
        if (this.layout == null) {
            this.layout = new ArrayList();
            this.layout.add(null);
        }
        while (true) {
            for (int y = 0; y < this.layout.size(); ++y) {
                ArrayList<JToggleButton> row = this.layout.get(y);
                if (row == null) {
                    row = new ArrayList();
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    this.layout.set(y, row);
                }
                for (int x = 0; x < row.size(); ++x) {
                    JToggleButton cell = row.get(x);
                    if (cell != null) continue;
                    row.set(x, btn);
                    this.add(btn);
                    return;
                }
            }
            this.layout.add(null);
        }
    }

    protected void addNote(int note) {
        JToggleButton prev = this.listDrums[note];
        if (prev == null) {
            String drumNote = _moduleInfo.getDrumSet().simpleGetDrum(note);
            String noteName = MXUtilMidi.nameOfNote(note);
            if (drumNote != null) {
                noteName = drumNote;
            }
            JToggleButton button = new JToggleButton(noteName);
            button.setPreferredSize(new Dimension(150, 40));
            this.listDrums[note] = button;
            this.buttonLayout(this.listDrums[note]);
        }
    }

    public void setSelected(int note, boolean push) {
        final JToggleButton btn = this.listDrums[note];
        if (btn == null) {
            return;
        }
        if (push) {
            btn.setSelected(true);
            this.timer = System.currentTimeMillis();
        } else {
            if (this.timer == 0L) {
                btn.setSelected(false);
            }
            MXTimer.letsCountdown(100L, new Runnable(){

                @Override
                public void run() {
                    btn.setSelected(false);
                }
            });
        }
    }

    public void noteOn(int note) {
        this.setSelected(note, true);
    }

    public void noteOff(int note) {
        this.setSelected(note, false);
    }

    private void initComponents() {
    }
}

