/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing.themes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.swing.themes.ThemeManager;
import jp.synthtarou.midimixer.mx30controller.CurvedSlider;

public class ThemeManagerDialog
extends JDialog {
    JFrame parentFrame;
    ThemeManager config;
    MXWrapList<String> _listModelFontName;
    MXWrapList<Integer> _listModelFontSyle;
    MXWrapList<Integer> _listModelFontSize;
    private JButton jButton7;
    private JButton jButtonAqua;
    private JButton jButtonForest;
    private JButton jButtonStone;
    private JButton jButtonWyne;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxFontName;
    private JComboBox jComboBoxFontSize;
    private JComboBox jComboBoxFontStyle;
    private JLabel jLabel1;
    private JLabel jLabelFill;
    private JPanel jPanel1;
    private JPanel jPanel1Colorful;
    private JPanel jPanel3;
    private JPanel jPanelCircle;
    private JPanel jPanelSystemTheme;

    public ThemeManagerDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parentFrame = parent;
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.config = ThemeManager.getInstance();
        this._listModelFontName = this.config.getFontNameModel();
        this._listModelFontSyle = this.config.getFontStyleModel();
        this._listModelFontSize = this.config.getFontSizeModel();
        this.jComboBoxFontName.setModel(this._listModelFontName);
        this.jComboBoxFontSize.setModel(this._listModelFontSize);
        this.jComboBoxFontStyle.setModel(this._listModelFontSyle);
        MXWrapList<String> listLaf = this.config.getLookAndFeelModel();
        for (MXWrap mXWrap : listLaf) {
            String name = mXWrap.name;
            JButton button = new JButton(name);
            button.addActionListener(new LookAndFeelThemeAction(name));
            this.jPanelSystemTheme.add(button);
        }
        this.pack();
        this.setPreferredSize(new Dimension(400, 400));
        CurvedSlider curve = new CurvedSlider(35);
        curve.setRange(0, 127);
        curve.setInverted(false);
        this.jLabelFill.setText("");
        this.jCheckBox1.setSelected(CurvedSlider.isMouseCircleIsCircle());
        this.jPanelCircle.add(curve);
    }

    private void initComponents() {
        this.jButton7 = new JButton();
        this.jPanel1Colorful = new JPanel();
        this.jButtonAqua = new JButton();
        this.jButtonWyne = new JButton();
        this.jButtonForest = new JButton();
        this.jButtonStone = new JButton();
        this.jPanelSystemTheme = new JPanel();
        this.jPanel3 = new JPanel();
        this.jComboBoxFontName = new JComboBox();
        this.jComboBoxFontStyle = new JComboBox();
        this.jComboBoxFontSize = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jPanelCircle = new JPanel();
        this.jLabelFill = new JLabel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jButton7.setText("OK");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jButton7ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jButton7, gridBagConstraints);
        this.jPanel1Colorful.setBorder(BorderFactory.createTitledBorder("\u30ab\u30e9\u30d5\u30eb\u30c6\u30fc\u30de"));
        this.jPanel1Colorful.setLayout(new GridBagLayout());
        this.jButtonAqua.setText("Aqua");
        this.jButtonAqua.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jButtonAquaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel1Colorful.add((Component)this.jButtonAqua, gridBagConstraints);
        this.jButtonWyne.setText("Wyne");
        this.jButtonWyne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jButtonWyneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel1Colorful.add((Component)this.jButtonWyne, gridBagConstraints);
        this.jButtonForest.setText("Forest");
        this.jButtonForest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jButtonForestActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel1Colorful.add((Component)this.jButtonForest, gridBagConstraints);
        this.jButtonStone.setText("Midnight");
        this.jButtonStone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jButtonStoneActionPerformed(evt);
            }
        });
        this.jPanel1Colorful.add((Component)this.jButtonStone, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1Colorful, gridBagConstraints);
        this.jPanelSystemTheme.setBorder(BorderFactory.createTitledBorder("\u30b7\u30b9\u30c6\u30e0\u30c6\u30fc\u30de"));
        this.jPanelSystemTheme.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanelSystemTheme, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("\u30d5\u30a9\u30f3\u30c8"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jComboBoxFontName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jComboBoxFontNameActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jComboBoxFontName, new GridBagConstraints());
        this.jComboBoxFontStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jComboBoxFontStyleActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jComboBoxFontStyle, new GridBagConstraints());
        this.jComboBoxFontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jComboBoxFontSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jComboBoxFontSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Another"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jCheckBox1.setText("Citrcle is Circle (Mouse Drag Mode)");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeManagerDialog.this.jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jLabel1.setText("Test");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jPanelCircle, gridBagConstraints);
        this.jLabelFill.setText("Fill");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelFill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonAquaActionPerformed(ActionEvent evt) {
        this.config.themeName = ThemeManager.additionalTheme[0];
        this.updateLookAndFeel();
    }

    private void jButtonWyneActionPerformed(ActionEvent evt) {
        this.config.themeName = ThemeManager.additionalTheme[2];
        this.updateLookAndFeel();
    }

    private void jButtonForestActionPerformed(ActionEvent evt) {
        this.config.themeName = ThemeManager.additionalTheme[1];
        this.updateLookAndFeel();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonStoneActionPerformed(ActionEvent evt) {
        this.config.themeName = ThemeManager.additionalTheme[3];
        this.updateLookAndFeel();
    }

    private void jComboBoxFontSizeActionPerformed(ActionEvent evt) {
        this.config.fontSize = this._listModelFontSize.readCombobox(this.jComboBoxFontSize);
        this.updateLookAndFeel();
    }

    private void jComboBoxFontNameActionPerformed(ActionEvent evt) {
        this.config.fontName = this._listModelFontName.readCombobox(this.jComboBoxFontName);
        this.updateLookAndFeel();
    }

    private void jComboBoxFontStyleActionPerformed(ActionEvent evt) {
        this.config.fontStyle = this._listModelFontSyle.readCombobox(this.jComboBoxFontStyle);
        this.updateLookAndFeel();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        CurvedSlider.setMouseCircleIsCircle(this.jCheckBox1.isSelected());
    }

    public void updateLookAndFeel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeManagerDialog.this.config.setUITheme(ThemeManagerDialog.this.config.themeName);
                ThemeManagerDialog.this.config.setFont(ThemeManagerDialog.this.config.fontName, ThemeManagerDialog.this.config.fontStyle, ThemeManagerDialog.this.config.fontSize);
                ThemeManagerDialog.this.config.updateUITree();
            }
        });
    }

    class LookAndFeelThemeAction
    implements ActionListener {
        String _theme;

        LookAndFeelThemeAction(String theme) {
            this._theme = theme;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThemeManagerDialog.this.config.themeName = this._theme;
            ThemeManagerDialog.this.updateLookAndFeel();
        }
    }
}

