/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXTimer;

public class MXButtonUILabel {
    String _title;
    JLabel _toInstall;
    long timer = 0L;

    public MXButtonUILabel(JLabel toInstall, final Runnable target) {
        this._title = toInstall.getText();
        this._toInstall = toInstall;
        this._toInstall.setText("");
        this.setSelected(false);
        toInstall.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MXButtonUILabel.this.setSelected(false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MXButtonUILabel.this.setSelected(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MXButtonUILabel.this.setSelected(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MXButtonUILabel.this.setSelected(true);
                if (target != null) {
                    target.run();
                    MXButtonUILabel.this.setSelected(false);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                MXButtonUILabel.this.setSelected(false);
            }
        });
    }

    public JLabel getLabel() {
        return this._toInstall;
    }

    public Dimension getSize() {
        return this._toInstall.getSize();
    }

    public void setSelected(boolean push) {
        if (push) {
            this._toInstall.setIcon(new SelectedButtonIcon(this._title));
            this.timer = System.currentTimeMillis();
            MXTimer.letsCountdown(100L, new Runnable(){

                @Override
                public void run() {
                    if (MXButtonUILabel.this.timer + 100L >= System.currentTimeMillis()) {
                        MXButtonUILabel.this._toInstall.setIcon(new ButtonIcon(MXButtonUILabel.this._title));
                    }
                }
            });
        } else {
            if (this.timer == 0L) {
                this._toInstall.setIcon(new ButtonIcon(this._title));
            }
            this.timer = System.currentTimeMillis();
            MXTimer.letsCountdown(100L, new Runnable(){

                @Override
                public void run() {
                    if (MXButtonUILabel.this.timer + 100L >= System.currentTimeMillis()) {
                        MXButtonUILabel.this._toInstall.setIcon(new ButtonIcon(MXButtonUILabel.this._title));
                    }
                }
            });
        }
    }

    class SelectedButtonIcon
    implements Icon {
        int preWidth;
        int preHeight;
        private final JToggleButton _component;

        public SelectedButtonIcon(String text) {
            this._component = new JToggleButton(text);
            this._component.setSelected(true);
            this.preWidth = Math.max(MXButtonUILabel.this.getSize().width, this._component.getPreferredSize().width);
            this.preHeight = Math.max(MXButtonUILabel.this.getSize().height, this._component.getPreferredSize().height);
        }

        @Override
        public int getIconWidth() {
            return this.preWidth;
        }

        @Override
        public int getIconHeight() {
            return this.preHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this._component.setSize(new Dimension(this.getIconWidth(), this.getIconHeight()));
            SwingUtilities.paintComponent(g, this._component, c.getParent(), x, y, this.getIconWidth(), this.getIconHeight());
        }
    }

    class ButtonIcon
    implements Icon {
        private final JButton _component;
        int preWidth;
        int preHeight;

        public ButtonIcon(String text) {
            this._component = new JButton(text);
            this.preWidth = Math.max(MXButtonUILabel.this.getSize().width, this._component.getPreferredSize().width);
            this.preHeight = Math.max(MXButtonUILabel.this.getSize().height, this._component.getPreferredSize().height);
        }

        @Override
        public int getIconWidth() {
            return this.preWidth;
        }

        @Override
        public int getIconHeight() {
            return this.preHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this._component.setSize(new Dimension(this.getIconWidth(), this.getIconHeight()));
            SwingUtilities.paintComponent(g, this._component, c.getParent(), x, y, this.getIconWidth(), this.getIconHeight());
        }
    }
}

