/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.programlist.database;

import java.util.Collection;
import jp.synthtarou.midimixer.libs.MXDebugLines;
import jp.synthtarou.midimixer.libs.midi.programlist.database.DoubleIndex;
import jp.synthtarou.midimixer.libs.midi.programlist.database.DoubleIndexElement;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDDrumSet;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDMap;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDProgram;

public class PDModule
implements DoubleIndexElement {
    private static final MXDebugLines _debug = new MXDebugLines(PDModule.class);
    DoubleIndex<PDMap> _mapSet = new DoubleIndex();
    DoubleIndex<PDProgram> _database;
    String _moduleName;
    PDDrumSet _drumSet = null;
    PDMap _root;
    PDProgram[] _listProgram;
    static int _seqOrder = 100;
    int _seq = _seqOrder;

    public PDModule() {
        this("");
    }

    public PDModule(String name) {
        this._moduleName = name;
    }

    public PDBank simpleGet(int programNumber, int msb, int lsb) {
        PDProgram prog;
        if (this._database == null) {
            this._database = this.createDatabase();
        }
        if ((prog = this._database.get(programNumber)) != null) {
            PDBank bank;
            if (msb >= 0 && lsb >= 0 && (bank = prog.get(msb, lsb)) != null) {
                return bank;
            }
            return prog._bankMap.first();
        }
        return null;
    }

    public String simpleGetName(int programNumber, int msb, int lsb) {
        PDBank bank = this.simpleGet(programNumber, msb, lsb);
        if (bank != null) {
            return bank.getName();
        }
        return null;
    }

    public String simpleGetDrum(int note) {
        if (this._drumSet == null) {
            for (PDMap map : this._mapSet.values()) {
                for (PDProgram program : map.listPrograms()) {
                    if (program._bankMap.size() == 0) {
                        program.smartReserve(-1, -1, program.getName());
                    }
                    for (PDBank bank : program.listBanks()) {
                        PDDrumSet drum = bank.getDrum();
                        if (drum == null) continue;
                        this._drumSet = drum;
                    }
                }
            }
            if (this._drumSet == null) {
                return "";
            }
        }
        return this._drumSet.getNote(note);
    }

    public void dump() {
        for (PDMap map : this._mapSet.values()) {
            System.out.println("MAP " + map.getId() + ":" + map.getName());
            for (PDProgram program : map.listPrograms()) {
                System.out.println("  PROGRAM " + program.getId() + ":" + program.getName());
                if (program._bankMap.size() == 0) {
                    program.smartReserve(-1, -1, program.getName());
                }
                for (PDBank bank : program.listBanks()) {
                    System.out.println("   BANK " + bank.getBankMSB() + "-" + bank.getBankLSB() + ":" + bank.getName());
                    PDDrumSet drum = bank.getDrum();
                    if (drum == null) continue;
                    for (int i = 0; i < 256; ++i) {
                        String dname = drum.getNote(i);
                        if (dname == null) continue;
                        System.out.println("    DRUM " + i + ":" + dname);
                    }
                }
            }
        }
    }

    public DoubleIndex<PDProgram> createDatabase() {
        DoubleIndex<PDProgram> ret = new DoubleIndex<PDProgram>();
        for (PDMap map : this._mapSet.values()) {
            for (PDProgram program : map.listPrograms()) {
                ret.put(program);
                if (program._bankMap.size() != 0) continue;
                program.smartReserve(-1, -1, program.getName());
            }
        }
        return ret;
    }

    public String simpleGetName(int programNumber) {
        return this.simpleGetName(programNumber, -1, -1);
    }

    public PDMap get(String name) {
        return this._mapSet.get(name);
    }

    public PDMap smartReserve(String name) {
        PDMap x = this.get(name);
        if (x == null) {
            x = new PDMap(name);
            this._mapSet.put(x);
        }
        return x;
    }

    @Override
    public int getId() {
        return this._seq;
    }

    @Override
    public String getName() {
        return this._moduleName;
    }

    public Collection<PDMap> listMap() {
        return this._mapSet.values();
    }
}

